/*
 * Copyright (c) 1999, 2015, Oracle and/or its affiliates. All rights reserved.
 */

package $packageName$;

import org.eclipse.swt.widgets.Label;

import com.jrockit.mc.rjmx.subscription.IMRIValueListener;
import com.jrockit.mc.rjmx.subscription.MRIValueEvent;
import com.jrockit.mc.ui.misc.DisplayToolkit;

public class LabelUpdater implements IMRIValueListener {
	private final Label label;

	public LabelUpdater(Label label) {
		this.label = label;
	}

	public void valueChanged(final MRIValueEvent event) {
		DisplayToolkit.safeAsyncExec(label, new Runnable() {
			public void run() {
				Double latestValue = (Double) event.getValue();
				label.setText("CPU Load is: " + (latestValue.doubleValue() * 100) + "%");
			}
		});
	}
}