/*
 * Copyright (c) 1999, 2015, Oracle and/or its affiliates. All rights reserved.
 */

package $packageName$;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormPage;

import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.subscription.ISubscriptionService;
import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.rjmx.subscription.MRI.Type;

/**
 * Simple example that shows the CPU Load. This tab will only work with a JDK
 * level 1.7 version of Hotspot and above, since we're explicitly referring to the 
 * CPU load attribute of a particular MBean.
 */
@SuppressWarnings("nls")
public class $className$ extends FormPage {
	/**
	 * During initialization of the Tab, the Java Mission Control Console
	 * will set up editor, id and title automatically.
	 */
	public $className$() {
		super(null, "", "");
	}

	private IConnectionHandle getConnectionHandle() {
		return (IConnectionHandle) getEditor().getAdapter(IConnectionHandle.class);
	}

	/**
	 * Populates the {@link IManagedForm} with a {@link Label} that subscribes
	 * on the CPU load attribute.
	 * 
	 * @param managedForm
	 *            the form hosted in this page.
	 */
	protected void createFormContent(IManagedForm managedForm) {
		managedForm.getToolkit().decorateFormHeading(managedForm.getForm().getForm());
		final Label valueLabel = managedForm.getToolkit().createLabel(
				managedForm.getForm().getBody(), "", SWT.CENTER);
		managedForm.getForm().getBody().setLayout(new FillLayout());
		getConnectionHandle().getServiceOrDummy(ISubscriptionService.class)
				.addMRIValueListener(
						new MRI(Type.ATTRIBUTE, "java.lang:type=OperatingSystem","ProcessCpuLoad"),
						new LabelUpdater(valueLabel));
	}
}
