/*
 * Copyright (c) 1999, 2015, Oracle and/or its affiliates. All rights reserved.
 */

package $packageName$;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormPage;

import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.rjmx.subscription.MRI.Type;
import com.jrockit.mc.rjmx.ui.AttributeVisualizerBuilder;

/**
 * Complex example showing how to expose three different attributes
 * through three different graphical components.
 * 
 * The end result will look a little bit like the Overview Tab.
 */
@SuppressWarnings("nls")
public class $className$ extends FormPage {
	
	public $className$() {
		super(null, "", "");
	}
	
	/**
	 * Populates the {@link IManagedForm} with three attribute section parts.
	 * 
	 * @param managedForm the form hosted in this page. 
	 */
	protected void createFormContent(IManagedForm managedForm) {
		managedForm.getToolkit().decorateFormHeading(managedForm.getForm().getForm());
		Composite body = managedForm.getForm().getBody();
		body.setLayout(new FillLayout(SWT.VERTICAL));
		IConnectionHandle connection = (IConnectionHandle) getEditor().getAdapter(IConnectionHandle.class);
		MRI memoryUsage = new MRI(Type.ATTRIBUTE, "java.lang:type=Memory", "HeapMemoryUsage/used");
		MRI liveSet = new MRI(Type.ATTRIBUTE, "com.sun.management:type=GarbageCollectionAggregator", "HeapLiveSet");
		MRI processCpu = new MRI(Type.ATTRIBUTE, "java.lang:type=OperatingSystem", "ProcessCpuLoad");
		MRI systemCpu = new MRI(Type.ATTRIBUTE, "java.lang:type=OperatingSystem", "SystemCpuLoad");

		// Creates a dash-board with three dials
		AttributeVisualizerBuilder.createDialDashboard(managedForm, body, connection, "Dials").add(memoryUsage, processCpu, liveSet);

		// Create and initialize a chart
		AttributeVisualizerBuilder.createChart(managedForm, body, connection, "Chart").add(processCpu, systemCpu);

		// Create and initialize a table
		AttributeVisualizerBuilder.createTable(managedForm, body, connection, "Table").add(memoryUsage, liveSet, processCpu, systemCpu);
	}

}
