/*
 * Copyright (c) 1999, 2015, Oracle and/or its affiliates. All rights reserved.
 */

package $packageName$;

import com.jrockit.mc.rjmx.triggers.TriggerEvent;
import com.jrockit.mc.rjmx.triggers.TriggerAction;

/**
 * Simple test action that just logs the NotificationEvent on System.out.
 */
@SuppressWarnings("nls")
public class $className$ extends TriggerAction {
	/**
	 * @see TriggerAction#handleNotificationEvent(NotificationEvent)
	 */
	public void handleNotificationEvent(TriggerEvent e) {
		printEvent(e);
	}

	/**
	 * Output this event at the command line.
	 * 
	 * @param e
	 *            the event
	 */
	private static void printEvent(TriggerEvent e) {
		System.out.println("========== Notification Alert! ==========");
		System.out.println("Notification creation time was: " + e.getCreationTime());
		System.out.println("The notification source is: " + e.getConnectorSourceDescription());
		System.out.println("The notification rule is: " + e.getRule().getName());
		System.out.println("Rule trigger condition: " + e.getRule().getTrigger().getValueEvaluator());
		System.out.println("=========================================\n");
	}
}
