/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ide.launch.model;

import com.jrockit.mc.common.io.IOToolkit;
import com.jrockit.mc.common.unit.QuantityConversionException;
import com.jrockit.mc.common.version.JavaVersion;
import com.jrockit.mc.common.version.JavaVersionSupport;
import com.jrockit.mc.core.idesupport.IDESupportToolkit;
import com.jrockit.mc.flightrecorder.configuration.IRecordingConfiguration;
import com.jrockit.mc.flightrecorder.controlpanel.ui.ControlPanel;
import com.jrockit.mc.flightrecorder.controlpanel.ui.messages.internal.Messages;
import com.jrockit.mc.flightrecorder.controlpanel.ui.model.RecordingTemplate;
import com.jrockit.mc.flightrecorder.controlpanel.ui.model.RecordingTemplateRepository;
import com.jrockit.mc.flightrecorder.controlpanel.ui.wizards.RecordingWizardModel;
import com.jrockit.mc.ide.launch.model.JFRArgsBuilder;
import com.jrockit.mc.ide.launch.model.JREFileRecordingConfiguration;
import com.jrockit.mc.ide.launch.model.NullFlightRecorderService;
import com.jrockit.mc.rjmx.services.flr.IFlightRecorderService;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Stack;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;

public class JFRLaunchModel
extends RecordingWizardModel {
    public static final String JRE_SUPPORTS_DUMPONEXIT_CHANGED = "jreSupportsDumpOnExitChanged";
    private static final String TEMPLATE_FILEEXTENSION = ".jfc";
    private static final String LIB_JFR = "lib/jfr";
    private static final String JRE_LIB_JFR = "jre/lib/jfr";
    private static final String EMPTY = "";
    private static final boolean DEFAULT_ENABLED = false;
    private static final boolean DEFAULT_AUTO_OPEN = false;
    private static final String DEFAULT_SETTINGS = "default";
    private static final String DEFAULT_NAME = Messages.RECORDING_DESCRIPTOR_DEFAULT_NAME;
    private static final boolean DEFAULT_CONTINUOUS = true;
    private static final String ENABLED_ATTRIBUTE = "jmc.jfr.launching.JFR.ENABLED";
    private static final String AUTO_OPEN_ATTRIBUTE = "jmc.jfr.launching.JFR.AUTO_OPEN";
    private static final String DURATION_ATTRIBUTE = "jmc.jfr.launching.JFR.DURATION";
    private static final String DELAY_ATTRIBUTE = "jmc.jfr.launching.JFR.DELAY";
    private static final String SETTINGS_ATTRIBUTE = "jmc.jfr.launching.JFR.SETTINGS";
    private static final String FILENAME_ATTRIBUTE = "jmc.jfr.launching.JFR.FILENAME";
    private static final String NAME_ATTRIBUTE = "jmc.jfr.launching.JFR.NAME";
    private static final String CONTINUOUS_ATTRIBUTE = "jmc.jfr.launching.JFR.CONTINUOUS";
    private File jreRoot;
    private String jreVersion;
    private boolean m_autoOpen;
    private boolean m_jfrEnabled = true;
    private boolean jreSupportsDumpOnExitWithoutDefaultRecording;

    public JFRLaunchModel(boolean jfrEnabled, boolean autoOpen) {
        super((IFlightRecorderService)new NullFlightRecorderService(), ControlPanel.getDefaultRecordingFile((String)EMPTY));
        this.setFixedRecording(false);
        this.setJFREnabled(jfrEnabled);
        this.setAutoOpen(autoOpen);
    }

    public JFRLaunchModel() {
        this(false, false);
    }

    protected RecordingTemplateRepository createRepository() {
        RecordingTemplateRepository repo = super.createRepository();
        repo.setPrototypeTemplate(null);
        return repo;
    }

    public String checkForErrors() {
        return super.checkForErrors();
    }

    public String getTemplatePath() {
        return this.getTemplatePath(this.getActiveConfiguration());
    }

    public String getTemplatePath(IRecordingConfiguration config) {
        if (config instanceof RecordingTemplate) {
            File locationFile = ((RecordingTemplate)config).getLocationFile();
            if (locationFile != null) {
                return ((RecordingTemplate)config).getLocationFile().getAbsolutePath();
            }
        } else if (config instanceof JREFileRecordingConfiguration) {
            return config.getName();
        }
        return EMPTY;
    }

    public void setTemplate(String templateLocation) {
        if (templateLocation != null) {
            IRecordingConfiguration selectConfig = null;
            for (IRecordingConfiguration config : this.getTemplateRepository().getAllTemplates()) {
                if (selectConfig == null) {
                    selectConfig = config;
                }
                if (!templateLocation.equals(this.getTemplatePath(config))) continue;
                selectConfig = config;
                break;
            }
            this.setActiveConfigurationTemplate(selectConfig);
        }
    }

    public boolean updateFromJREConfiguration(ILaunchConfiguration configuration) throws CoreException {
        File newJreRoot = JFRLaunchModel.getJRERoot(configuration);
        String newJreVersion = JFRLaunchModel.getJREVersion(configuration);
        if (!newJreVersion.equals(this.jreVersion) || !newJreRoot.equals(this.jreRoot)) {
            IRecordingConfiguration oldSettings;
            IRecordingConfiguration newSettings = oldSettings = this.getActiveConfiguration();
            if (this.removeOldConfigs(oldSettings)) {
                newSettings = null;
            }
            this.jreRoot = newJreRoot;
            this.jreVersion = newJreVersion;
            for (File jfcFile : JFRLaunchModel.findJFCFiles(this.jreRoot)) {
                JREFileRecordingConfiguration jreConfig = new JREFileRecordingConfiguration();
                jreConfig.setLocationInfo(this.jreVersion);
                jreConfig.setName(jfcFile.getName().replaceAll(TEMPLATE_FILEEXTENSION, EMPTY));
                this.getTemplateRepository().add((IRecordingConfiguration)jreConfig);
                if (newSettings != null && !configuration.getAttribute(SETTINGS_ATTRIBUTE, DEFAULT_SETTINGS).equals(jreConfig.getName())) continue;
                newSettings = jreConfig;
            }
            this.setActiveConfigurationTemplate(newSettings);
            boolean oldSupportsDumpOnExit = this.jreSupportsDumpOnExitWithoutDefaultRecording;
            this.jreSupportsDumpOnExitWithoutDefaultRecording = JFRLaunchModel.supportsDumpOnExitWithoutDefaultRecording(this.jreRoot);
            if (oldSupportsDumpOnExit != this.jreSupportsDumpOnExitWithoutDefaultRecording) {
                this.setChanged();
                this.notifyObservers(JRE_SUPPORTS_DUMPONEXIT_CHANGED);
            }
            return true;
        }
        return false;
    }

    private boolean removeOldConfigs(IRecordingConfiguration oldSettings) {
        ArrayList<IRecordingConfiguration> removeConfigs = new ArrayList<IRecordingConfiguration>();
        for (IRecordingConfiguration config : this.getTemplateRepository().getAllTemplates()) {
            if (!(config instanceof JREFileRecordingConfiguration) || !config.getLocationInfo().equals(this.jreVersion)) continue;
            removeConfigs.add(config);
        }
        for (IRecordingConfiguration config : removeConfigs) {
            this.getTemplateRepository().remove(config);
        }
        return removeConfigs.contains(oldSettings);
    }

    private static Collection<File> findJFCFiles(File jreRoot) {
        Collection<Object> jfcFiles = Collections.emptyList();
        File jfcDir = new File(jreRoot, JRE_LIB_JFR);
        if (jfcDir.exists()) {
            jfcFiles = JFRLaunchModel.findJFCFilesInDir(jfcDir);
        } else {
            jfcDir = new File(jreRoot, LIB_JFR);
            if (jfcDir.exists()) {
                jfcFiles = JFRLaunchModel.findJFCFilesInDir(jfcDir);
            }
        }
        return jfcFiles;
    }

    private static Collection<File> findJFCFilesInDir(File jfcDir) {
        return Arrays.asList(jfcDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isFile() && pathname.getAbsolutePath().endsWith(JFRLaunchModel.TEMPLATE_FILEEXTENSION);
            }
        }));
    }

    public void updateFromConfiguration(ILaunchConfiguration configuration) throws CoreException, QuantityConversionException {
        this.updateFromJREConfiguration(configuration);
        this.updateJFRLaunchFromConfiguration(configuration);
    }

    private void updateJFRLaunchFromConfiguration(ILaunchConfiguration configuration) throws CoreException, QuantityConversionException {
        this.setJFREnabled(configuration.getAttribute(ENABLED_ATTRIBUTE, false));
        this.setAutoOpen(configuration.getAttribute(AUTO_OPEN_ATTRIBUTE, false));
        this.setDuration(configuration.getAttribute(DURATION_ATTRIBUTE, DEFAULT_DURATION_STRING));
        this.setDelay(configuration.getAttribute(DELAY_ATTRIBUTE, DEFAULT_DELAY_STRING));
        this.setName(configuration.getAttribute(NAME_ATTRIBUTE, DEFAULT_NAME));
        String filePath = configuration.getAttribute(FILENAME_ATTRIBUTE, null);
        if (filePath != null) {
            this.setPath(IDESupportToolkit.createFileResource((String)filePath));
        }
        this.setFixedRecording(!configuration.getAttribute(CONTINUOUS_ATTRIBUTE, true));
        this.setTemplate(configuration.getAttribute(SETTINGS_ATTRIBUTE, DEFAULT_SETTINGS));
    }

    private static File getJRERoot(ILaunchConfiguration configuration) throws CoreException {
        IVMInstall vmInstall = JavaRuntime.computeVMInstall((ILaunchConfiguration)configuration);
        return vmInstall == null ? null : vmInstall.getInstallLocation();
    }

    private static String getJREVersion(ILaunchConfiguration configuration) throws CoreException {
        IVMInstall vmInstall = JavaRuntime.computeVMInstall((ILaunchConfiguration)configuration);
        return vmInstall == null ? null : vmInstall.getName();
    }

    public void updateToConfiguration(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(ENABLED_ATTRIBUTE, this.isJFREnabled());
        configuration.setAttribute(AUTO_OPEN_ATTRIBUTE, this.getAutoOpen());
        configuration.setAttribute(DURATION_ATTRIBUTE, this.getDurationString());
        configuration.setAttribute(DELAY_ATTRIBUTE, this.getDelayString());
        configuration.setAttribute(SETTINGS_ATTRIBUTE, this.getTemplatePath());
        configuration.setAttribute(NAME_ATTRIBUTE, this.getName());
        configuration.setAttribute(FILENAME_ATTRIBUTE, this.getPath().getPath());
        configuration.setAttribute(CONTINUOUS_ATTRIBUTE, this.isContinuous());
    }

    public void setAutoOpen(boolean autoOpen) {
        this.m_autoOpen = autoOpen;
        this.onChange();
    }

    public boolean getAutoOpen() {
        return this.m_autoOpen;
    }

    public boolean isJFREnabled() {
        return this.m_jfrEnabled;
    }

    public void setJFREnabled(boolean enabled) {
        this.m_jfrEnabled = enabled;
        this.onChange();
    }

    public JFRArgsBuilder createArgsBuilder() throws IOException {
        return new JFRArgsBuilder(this.isJFREnabled(), this.jreSupportsDumpOnExitWithoutDefaultRecording, this.getDurationString(), this.getDelayString(), this.getTemplatePath(), this.getRecordingFile().getAbsolutePath(), this.getName(), this.isContinuous());
    }

    public File getRecordingFile() throws FileNotFoundException {
        Path path = new Path(this.getPath().getPath());
        File base = null;
        Stack<String> segments = new Stack<String>();
        while (path.segmentCount() != 0) {
            try {
                segments.push(path.lastSegment());
                path = path.removeLastSegments(1);
                base = IDESupportToolkit.resolveFileSystemPath((String)path.toOSString());
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            if (base == null) continue;
        }
        if (base == null) {
            throw new FileNotFoundException("Can't resolve file " + this.getPath().getPath());
        }
        File f = base;
        while (!segments.empty()) {
            f = new File(f, (String)segments.pop());
        }
        return f;
    }

    public boolean isJreSupportsDumpOnExitWithoutDefaultRecording() {
        return this.jreSupportsDumpOnExitWithoutDefaultRecording;
    }

    /*
     * Loose catch block
     */
    private static boolean supportsDumpOnExitWithoutDefaultRecording(File theJreRoot) {
        block6: {
            JarInputStream jis;
            FileInputStream fis;
            block5: {
                boolean bl;
                fis = null;
                jis = null;
                try {
                    File rtJar = new File(theJreRoot, "jre/lib/rt.jar");
                    if (!rtJar.exists()) {
                        rtJar = new File(theJreRoot, "lib/rt.jar");
                    }
                    if (!rtJar.exists()) break block5;
                    fis = new FileInputStream(rtJar);
                    jis = new JarInputStream(fis);
                    Manifest mf = jis.getManifest();
                    jis.close();
                    Attributes as = mf.getMainAttributes();
                    String impVer = as.getValue("Implementation-Version");
                    if (impVer == null) break block5;
                    bl = new JavaVersion(impVer).isGreaterOrEqualThan(JavaVersionSupport.DUMP_ON_EXIT_WITHOUT_DEFAULTRECORDING_SUPPORTED);
                }
                catch (IOException iOException) {
                    IOToolkit.closeSilently(jis);
                    IOToolkit.closeSilently(fis);
                    break block6;
                    catch (Throwable throwable) {
                        IOToolkit.closeSilently(jis);
                        IOToolkit.closeSilently(fis);
                        throw throwable;
                    }
                }
                IOToolkit.closeSilently((Closeable)jis);
                IOToolkit.closeSilently((Closeable)fis);
                return bl;
            }
            IOToolkit.closeSilently(jis);
            IOToolkit.closeSilently(fis);
        }
        return false;
    }

    public String getShortConfigurationDescription() {
        return "JFR enabled=" + this.isJFREnabled() + ", Open automatically=" + this.getAutoOpen() + ", Continuous=" + this.isContinuous();
    }
}

