/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ide.launch.model;

import com.jrockit.mc.common.string.StringToolkit;
import com.jrockit.mc.common.unit.QuantityConversionException;
import com.jrockit.mc.common.util.TimeRangeToolkit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

public class JFRArgsBuilder {
    private static final String UNLOCKCOMMERCIAL_ARGUMENT = "-XX:+UnlockCommercialFeatures";
    private static final String FLIGHTRECORDER_ARGUMENT = "-XX:+FlightRecorder";
    private static final String STARTFLIGHTRECORDING_ARGUMENT = "-XX:StartFlightRecording=";
    private static final String FLIGHTRECORDEROPTIONS_ARGUMENT = "-XX:FlightRecorderOptions=";
    private static final String DURATION_ARGUMENT = "duration=";
    private static final String DELAY_ARGUMENT = "delay=";
    private static final String FILENAME_ARGUMENT = "filename=";
    private static final String NAME_ARGUMENT = "name=";
    private static final String SETTINGS_ARGUMENT = "settings=";
    private static final String DEFAULTRECORDING_ARGUMENT = "defaultrecording=";
    private static final String DUMPONEXIT_ARGUMENT = "dumponexit=";
    private static final String DUMPONEXITPATH_ARGUMENT = "dumponexitpath=";
    private static final String EMPTY = "";
    private static final String COMMA = ",";
    private static final String QUOT = "\"";
    private static final String SPACE = " ";
    private static final String WHITESPACE_PATTERN = ".*\\s.*";
    private static final String TRUE = "true";
    private static final String ARG_DELIM_AND_START = " -";
    private static final String ARG_START = "-";
    private final boolean jfrEnabled;
    private final String duration;
    private final String delay;
    private final String settings;
    private final String jfrFilename;
    private final String name;
    private final boolean continuous;
    private boolean supportsDumpOnExitWithoutDefaultRecording;

    public JFRArgsBuilder(boolean jfrEnabled, boolean supportsDumpOnExitWithoutDefaultRecording, String duration, String delay, String settings, String jfrFilename, String name, boolean continuous) {
        this.jfrEnabled = jfrEnabled;
        this.supportsDumpOnExitWithoutDefaultRecording = supportsDumpOnExitWithoutDefaultRecording;
        this.duration = duration;
        this.delay = delay;
        this.settings = settings;
        this.jfrFilename = jfrFilename;
        this.name = name;
        this.continuous = continuous;
    }

    public String[] getJFRArgs(boolean quotWhitespace) throws Exception {
        ArrayList<String> jfrArgs = new ArrayList<String>();
        if (this.jfrEnabled) {
            jfrArgs.add(UNLOCKCOMMERCIAL_ARGUMENT);
            jfrArgs.add(FLIGHTRECORDER_ARGUMENT);
            String validDuration = this.getValidTimeRange(this.duration);
            String validDelay = this.getValidTimeRange(this.delay);
            String adaptedFilename = this.getQuotedFilename(quotWhitespace);
            StringBuilder jfrStartArg = new StringBuilder();
            if (validDuration != null || validDelay != null || this.settings != null || this.name != null || this.jfrFilename != null || this.continuous) {
                jfrStartArg.append(STARTFLIGHTRECORDING_ARGUMENT);
            }
            if (this.continuous) {
                if (this.supportsDumpOnExitWithoutDefaultRecording) {
                    this.appendSettingsArg(quotWhitespace, jfrStartArg);
                    jfrStartArg.append(DUMPONEXIT_ARGUMENT).append(TRUE).append(COMMA);
                    this.appendNameArg(jfrStartArg);
                    jfrStartArg.append(FILENAME_ARGUMENT).append(adaptedFilename).append(COMMA);
                } else {
                    jfrStartArg.append(DEFAULTRECORDING_ARGUMENT).append(TRUE).append(COMMA);
                }
            } else {
                this.appendSettingsArg(quotWhitespace, jfrStartArg);
                if (validDuration != null) {
                    jfrStartArg.append(DURATION_ARGUMENT).append(validDuration).append(COMMA);
                }
                if (validDelay != null) {
                    jfrStartArg.append(DELAY_ARGUMENT).append(validDelay).append(COMMA);
                }
                this.appendNameArg(jfrStartArg);
                jfrStartArg.append(FILENAME_ARGUMENT).append(adaptedFilename).append(COMMA);
            }
            if (jfrStartArg.toString().endsWith(COMMA)) {
                jfrStartArg = jfrStartArg.deleteCharAt(jfrStartArg.length() - 1);
            }
            if (jfrStartArg.length() > 0) {
                jfrArgs.add(jfrStartArg.toString());
            }
            StringBuilder jfrOptionsArg = new StringBuilder();
            if (this.continuous && !this.supportsDumpOnExitWithoutDefaultRecording) {
                jfrOptionsArg.append(FLIGHTRECORDEROPTIONS_ARGUMENT);
                jfrOptionsArg.append(DUMPONEXIT_ARGUMENT).append(TRUE).append(COMMA);
                jfrOptionsArg.append(DUMPONEXITPATH_ARGUMENT).append(adaptedFilename).append(COMMA);
            }
            if (jfrOptionsArg.toString().endsWith(COMMA)) {
                jfrOptionsArg = jfrOptionsArg.deleteCharAt(jfrOptionsArg.length() - 1);
            }
            if (jfrOptionsArg.length() > 0) {
                jfrArgs.add(jfrOptionsArg.toString());
            }
        }
        return jfrArgs.toArray(new String[jfrArgs.size()]);
    }

    private void appendNameArg(StringBuilder jfrStartArg) {
        if (this.name != null && this.name.length() > 0) {
            String nameWithoutSpaces = this.name.replaceAll(SPACE, EMPTY);
            jfrStartArg.append(NAME_ARGUMENT).append(nameWithoutSpaces).append(COMMA);
        }
    }

    private void appendSettingsArg(boolean quotWhitespace, StringBuilder jfrStartArg) {
        if (this.settings != null && this.settings.length() > 0) {
            jfrStartArg.append(SETTINGS_ARGUMENT).append(this.getQuotedPath(this.settings, quotWhitespace)).append(COMMA);
        }
    }

    private String getQuotedFilename(boolean quotWhitespace) {
        return this.getQuotedPath(this.jfrFilename, quotWhitespace);
    }

    private String getQuotedPath(String path, boolean quotWhitespace) {
        return path.matches(WHITESPACE_PATTERN) && quotWhitespace ? QUOT + path + QUOT : path;
    }

    private String getValidTimeRange(String timerange) {
        block4: {
            if (timerange == null || timerange.length() == 0) {
                return null;
            }
            try {
                long nanos = TimeRangeToolkit.parseNanos((String)timerange);
                if (nanos >= 0L) break block4;
                return null;
            }
            catch (QuantityConversionException e) {
                return null;
            }
        }
        return TimeRangeToolkit.standardizeFormat((String)timerange, (TimeRangeToolkit.Format)TimeRangeToolkit.Format.JFR_OPTIONS, (boolean)false).replace(SPACE, EMPTY);
    }

    public static String cleanJFRArgsString(String origArgs) {
        return JFRArgsBuilder.joinToCommandline(JFRArgsBuilder.cleanJFRArgs(JFRArgsBuilder.splitCommandline(origArgs)));
    }

    public static String[] splitCommandline(String origArgs) {
        String[] origArray = origArgs.split(ARG_DELIM_AND_START);
        int i = 1;
        while (i < origArray.length) {
            origArray[i] = ARG_START + origArray[i];
            ++i;
        }
        return origArray;
    }

    public static String joinToCommandline(String[] allArgs) {
        String ARG_DELIM = SPACE;
        return StringToolkit.join(Arrays.asList(allArgs), (String)SPACE);
    }

    public static String[] cleanJFRArgs(String[] origArray) {
        String[] jfrArgPatterns = new String[]{"-XX:.?UnlockCommercialFeatures", "-XX:StartFlightRecording.*", "-XX:FlightRecorderOptions.*", "-XX:.?FlightRecorder"};
        ArrayList<String> argsList = new ArrayList<String>();
        argsList.addAll(Arrays.asList(origArray));
        Iterator iterator = argsList.iterator();
        while (iterator.hasNext()) {
            String arg = (String)iterator.next();
            int i = 0;
            while (i < jfrArgPatterns.length) {
                if (arg.matches(jfrArgPatterns[i])) {
                    iterator.remove();
                }
                ++i;
            }
        }
        return argsList.toArray(new String[argsList.size()]);
    }
}

