/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ide.launch;

import com.jrockit.mc.ide.launch.LaunchPlugin;
import com.jrockit.mc.ide.launch.Messages;
import com.jrockit.mc.ide.launch.model.JFRLaunchModel;
import com.jrockit.mc.ui.misc.DialogToolkit;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.widgets.Shell;

public class JFRLaunchShortcutHelper {
    protected static ILaunchConfigurationWorkingCopy updateLaunchConfigurationWithJFRSettings(ILaunchConfigurationWorkingCopy wc, String jfrLaunchDelegateId) {
        JFRLaunchModel model = new JFRLaunchModel(true, true);
        try {
            model.updateFromJREConfiguration((ILaunchConfiguration)wc);
            model.updateToConfiguration(wc);
            wc.setPreferredLaunchDelegate(JFRLaunchShortcutHelper.getJFRModes(), jfrLaunchDelegateId);
            File parent = model.getRecordingFile().getParentFile();
            if (parent.isDirectory() || parent.mkdirs()) {
                wc.doSave();
            } else {
                JFRLaunchShortcutHelper.displayExceptionDialog(new FileNotFoundException("Could not create the folder for the flight recording file: " + parent.getAbsolutePath()));
            }
        }
        catch (CoreException e) {
            JFRLaunchShortcutHelper.displayExceptionDialog((Exception)((Object)e));
        }
        catch (IOException e) {
            JFRLaunchShortcutHelper.displayExceptionDialog(e);
        }
        return wc;
    }

    private static Set<String> getJFRModes() {
        HashSet<String> modes = new HashSet<String>();
        modes.add("run");
        return modes;
    }

    protected static void displayExceptionDialog(Exception e) {
        DialogToolkit.showException((Shell)LaunchPlugin.getActiveWorkbenchShell(), (String)Messages.JFRLaunch_JFR_OPTIONS_PROBLEM, (Throwable)e);
    }
}

