/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ide.launch;

import com.jrockit.mc.flightrecorder.controlpanel.ui.wizards.RecordingWizardModel;
import com.jrockit.mc.flightrecorder.controlpanel.ui.wizards.RecordingWizardPage;
import com.jrockit.mc.ide.launch.Messages;
import com.jrockit.mc.ide.launch.model.JFRArgsBuilder;
import com.jrockit.mc.ide.launch.model.JFRLaunchModel;
import com.jrockit.mc.ui.misc.DialogToolkit;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class JFRLaunchPage
extends RecordingWizardPage
implements Observer {
    private Button enabledCheckbox;
    private Button autoOpenCheckbox;
    private JFRLaunchModel model;
    private Text vmArguments;

    public JFRLaunchPage(JFRLaunchModel model) {
        super((RecordingWizardModel)model, false, false, true, false, false, true, true, true);
        this.model = model;
        model.addObserver(this);
    }

    public void createControl(Composite parent) {
        int cols;
        Composite comp;
        block2: {
            comp = new Composite(parent, 0);
            cols = 2;
            comp.setLayout((Layout)new GridLayout(cols, false));
            GridData gd1 = new GridData(4, 4, true, true);
            comp.setLayoutData((Object)gd1);
            this.createEnabled(comp, cols);
            this.createOpenAutomatically(comp, cols);
            this.createSeparator(comp, cols);
            try {
                super.createControl(comp);
            }
            catch (NullPointerException npe) {
                StackTraceElement[] trace = npe.getStackTrace();
                if (trace.length > 0 && trace[0].getClassName().equals("com.jrockit.mc.flightrecorder.controlpanel.ui.wizards.RecordingWizardPage") && trace[0].getMethodName().equals("createControl")) break block2;
                throw npe;
            }
        }
        GridData gd2 = new GridData(4, 4, true, true);
        gd2.horizontalSpan = cols;
        super.getControl().setLayoutData((Object)gd2);
        Text t = this.createVMArgumentsText(comp);
        GridData gd3 = new GridData(4, 4, true, true);
        gd3.horizontalSpan = cols;
        gd3.widthHint = 20;
        t.setLayoutData((Object)gd3);
        this.setControl((Control)comp);
    }

    private void createSeparator(Composite comp, int cols) {
        Label sep = new Label(comp, 258);
        GridData gd2 = new GridData(4, 4, false, false);
        gd2.horizontalSpan = cols;
        sep.setLayoutData((Object)gd2);
    }

    private void createEnabled(Composite parent, int cols) {
        this.enabledCheckbox = new Button(parent, 32);
        this.enabledCheckbox.setText(Messages.JFRLaunch_ENABLE_JFR);
        this.enabledCheckbox.setToolTipText(Messages.JFRLaunch_ENABLE_JFR_TOOLTIP);
        this.enabledCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JFRLaunchPage.this.model.setJFREnabled(JFRLaunchPage.this.enabledCheckbox.getSelection());
            }
        });
        GridData gd = new GridData(4, 4, false, false);
        gd.horizontalSpan = 1;
        this.enabledCheckbox.setLayoutData((Object)gd);
    }

    private void createOpenAutomatically(Composite parent, int cols) {
        this.autoOpenCheckbox = new Button(parent, 32);
        this.autoOpenCheckbox.setText(Messages.JFRLaunch_AUTO_OPEN);
        this.autoOpenCheckbox.setToolTipText(Messages.JFRLaunch_AUTO_OPEN_TOOLTIP);
        this.autoOpenCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JFRLaunchPage.this.model.setAutoOpen(JFRLaunchPage.this.autoOpenCheckbox.getSelection());
            }
        });
        GridData gd = new GridData(4, 4, false, false);
        gd.horizontalSpan = cols - 1;
        this.autoOpenCheckbox.setLayoutData((Object)gd);
    }

    private Text createVMArgumentsText(Composite parent) {
        GridData gd1 = new GridData(4, 4, false, false);
        Label label = this.createLabel(parent, Messages.JFRLaunch_JVM_ARGS);
        label.setLayoutData((Object)gd1);
        this.vmArguments = new Text(parent, 2634);
        this.vmArguments.setEnabled(true);
        this.vmArguments.setToolTipText(Messages.JFRLaunch_JVM_ARGS_TOOLTIP);
        return this.vmArguments;
    }

    private void updateVMArgumentsText() {
        if (this.vmArguments != null) {
            try {
                this.vmArguments.setText(JFRArgsBuilder.joinToCommandline(this.model.createArgsBuilder().getJFRArgs(true)));
            }
            catch (Exception e) {
                DialogToolkit.showException((Shell)this.getShell(), (String)Messages.JFRLaunch_JFR_OPTIONS_PROBLEM, (Throwable)e);
                this.vmArguments.setText(Messages.JFRLaunch_JFR_OPTIONS_PROBLEM);
            }
        }
    }

    public void setJFREnabled(boolean jfrEnabled) {
        this.enabledCheckbox.setSelection(jfrEnabled);
    }

    public boolean isJFREnabled() {
        return this.enabledCheckbox.getSelection();
    }

    public void setAutoOpen(boolean autoOpen) {
        this.autoOpenCheckbox.setSelection(autoOpen);
    }

    public boolean getAutoOpen() {
        return this.autoOpenCheckbox.getSelection();
    }

    @Override
    public void update(Observable o, Object arg) {
        if (arg != null && arg.equals("jreSupportsDumpOnExitChanged")) {
            Boolean jreSupportsDumpOnExitWithoutDefaultRecording = this.model.isJreSupportsDumpOnExitWithoutDefaultRecording();
            this.setBehaviorForContinuous(jreSupportsDumpOnExitWithoutDefaultRecording == false, jreSupportsDumpOnExitWithoutDefaultRecording == false);
        } else {
            this.updateVMArgumentsText();
        }
    }
}

