/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ide.launch;

import com.jrockit.mc.common.io.IOToolkit;
import com.jrockit.mc.common.unit.QuantityConversionException;
import com.jrockit.mc.core.MCFile;
import com.jrockit.mc.ide.launch.LaunchPlugin;
import com.jrockit.mc.ide.launch.Messages;
import com.jrockit.mc.ide.launch.model.JFRArgsBuilder;
import com.jrockit.mc.ide.launch.model.JFRLaunchModel;
import com.jrockit.mc.ui.MCPathEditorInput;
import com.jrockit.mc.ui.WorkbenchToolkit;
import com.jrockit.mc.ui.misc.DialogToolkit;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IPathEditorInput;

public class JFRLaunchDelegateHelper {
    private static final int EXTRA_TIME_IN_MS_BEFORE_OPENING_JFR = 2000;
    private Thread recordingWaiter;
    private IDebugEventSetListener terminationListener;
    private MCFile jfrPathToOpen;
    private File recordingFile;

    public void preLaunch(ILaunchConfiguration configuration) throws CoreException {
        this.terminationListener = null;
        this.jfrPathToOpen = null;
        this.recordingWaiter = null;
        JFRLaunchModel model = JFRLaunchDelegateHelper.getModel(configuration);
        if (model.isJFREnabled()) {
            boolean autoOpen = model.getAutoOpen();
            boolean continuous = model.isContinuous();
            long delayPlusDuration = model.getDelay() + model.getDuration();
            this.logDebugMessage(String.format("Preparing for launch with JFR. Auto open=%s, continuous=%s, delayPlusDuration=%s", autoOpen, configuration, delayPlusDuration));
            this.jfrPathToOpen = model.getPath();
            this.recordingFile = JFRLaunchDelegateHelper.getRecordingFileInEnsuredDirectory(model);
            if (autoOpen) {
                if (continuous) {
                    this.terminationListener = this.createDumpOnExitListener();
                } else if (delayPlusDuration > 0L) {
                    this.recordingWaiter = this.createDurationWaiter(delayPlusDuration);
                    this.terminationListener = this.createInterruptWaiterListener();
                }
            }
            if (this.terminationListener != null) {
                DebugPlugin.getDefault().addDebugEventListener(this.terminationListener);
            }
        }
    }

    private static File getRecordingFileInEnsuredDirectory(JFRLaunchModel model) throws CoreException {
        try {
            File rf = model.getRecordingFile();
            File parent = rf.getParentFile();
            if (!parent.isDirectory() && !parent.mkdirs()) {
                throw new CoreException((IStatus)new Status(4, "com.jrockit.mc.ide.launch", "Could not create the folder for the flight recording file: " + parent.getAbsolutePath()));
            }
            return rf;
        }
        catch (FileNotFoundException e) {
            throw new CoreException((IStatus)new Status(4, "com.jrockit.mc.ide.launch", e.getLocalizedMessage()));
        }
    }

    private void logDebugMessage(String message) {
        if (Boolean.getBoolean("com.jrockit.mc.debug")) {
            LaunchPlugin.getDefault().getLogger().log(Level.FINE, message);
        }
    }

    public void postLaunch(ILaunchConfiguration configuration) throws CoreException {
        if (this.recordingWaiter != null) {
            this.recordingWaiter.start();
        }
    }

    public static String getVMArgsFromString(String origArgs, ILaunchConfiguration configuration, boolean quotWhitespace) {
        return JFRArgsBuilder.joinToCommandline(JFRLaunchDelegateHelper.getVMArgs(JFRArgsBuilder.splitCommandline(origArgs), configuration, quotWhitespace));
    }

    protected static String[] getVMArgs(String[] origArgs, ILaunchConfiguration configuration, boolean quotWhitespace) {
        JFRLaunchModel model = JFRLaunchDelegateHelper.getModel(configuration);
        if (model.isJFREnabled()) {
            String[] jfrArgs = new String[]{};
            try {
                JFRArgsBuilder argsBuilder = model.createArgsBuilder();
                LaunchPlugin.getDefault().getLogger().log(Level.INFO, "JFR Launch configuration: " + model.getShortConfigurationDescription());
                jfrArgs = argsBuilder.getJFRArgs(quotWhitespace);
            }
            catch (Exception e) {
                LaunchPlugin.getDefault().getLogger().log(Level.SEVERE, "Could not create jfr Args", e);
            }
            origArgs = JFRArgsBuilder.cleanJFRArgs(origArgs);
            String[] allArgs = new String[origArgs.length + jfrArgs.length];
            int i = 0;
            while (i < origArgs.length) {
                allArgs[i] = origArgs[i];
                ++i;
            }
            i = 0;
            while (i < jfrArgs.length) {
                allArgs[i + origArgs.length] = jfrArgs[i];
                ++i;
            }
            LaunchPlugin.getDefault().getLogger().log(Level.INFO, "VM arguments from JFR Launch : " + JFRArgsBuilder.joinToCommandline(allArgs));
            return allArgs;
        }
        return origArgs;
    }

    protected Thread createDurationWaiter(final long delayPlusDuration) {
        return new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(delayPlusDuration + 2000L);
                    JFRLaunchDelegateHelper.this.scheduleOpenJFRJob();
                }
                catch (InterruptedException e) {
                    LaunchPlugin.getDefault().getLogger().log(Level.WARNING, Messages.JFRLaunch_RECORDING_WAITER_INTERRUPTED);
                }
            }
        });
    }

    protected void removeTerminationListener() {
        DebugPlugin.getDefault().removeDebugEventListener(this.terminationListener);
    }

    protected IDebugEventSetListener createInterruptWaiterListener() {
        return new IDebugEventSetListener(){

            public void handleDebugEvents(DebugEvent[] events) {
                int i = 0;
                while (i < events.length) {
                    if (events[i].getKind() == 8 && JFRLaunchDelegateHelper.this.recordingWaiter != null && JFRLaunchDelegateHelper.this.recordingWaiter.isAlive()) {
                        JFRLaunchDelegateHelper.this.recordingWaiter.interrupt();
                    }
                    ++i;
                }
                JFRLaunchDelegateHelper.this.removeTerminationListener();
            }
        };
    }

    private IDebugEventSetListener createDumpOnExitListener() {
        return new IDebugEventSetListener(){

            public void handleDebugEvents(DebugEvent[] events) {
                int i = 0;
                while (i < events.length) {
                    if (events[i].getKind() == 8) {
                        JFRLaunchDelegateHelper.this.scheduleOpenJFRJob();
                        JFRLaunchDelegateHelper.this.removeTerminationListener();
                    }
                    ++i;
                }
            }
        };
    }

    /*
     * Loose catch block
     */
    protected void scheduleOpenJFRJob() {
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(this.recordingFile);
            boolean wrote = this.jfrPathToOpen.tryWriteStream((InputStream)stream, null);
            if (wrote) {
                String info = String.valueOf(this.recordingFile.getAbsolutePath()) + " was written to " + this.jfrPathToOpen.getPath() + " which is not expected. Should have existed after refresh.";
                LaunchPlugin.getDefault().getLogger().info(info);
            }
            WorkbenchToolkit.asyncOpenEditor((IPathEditorInput)new MCPathEditorInput(this.recordingFile));
        }
        catch (IOException iOException) {
            IOToolkit.closeSilently(stream);
            catch (Throwable throwable) {
                IOToolkit.closeSilently(stream);
                throw throwable;
            }
        }
        IOToolkit.closeSilently((Closeable)stream);
        return;
        this.displayErrorMessage(NLS.bind((String)Messages.JFRLaunch_JFR_FILE_DID_NOT_EXIST, (Object)this.jfrPathToOpen));
    }

    protected void displayErrorMessage(String message) {
        DialogToolkit.showErrorDialogAsync((Display)Display.getDefault(), (String)Messages.JFRLaunch_JFR_LAUNCH_PROBLEM_TITLE, (String)message);
    }

    protected static JFRLaunchModel getModel(ILaunchConfiguration configuration) {
        try {
            JFRLaunchModel model = new JFRLaunchModel();
            model.updateFromConfiguration(configuration);
            return model;
        }
        catch (CoreException e) {
            LaunchPlugin.getDefault().getLogger().log(Level.WARNING, Messages.JFRLaunch_CONFIG_EXCEPTION, e);
        }
        catch (QuantityConversionException e) {
            LaunchPlugin.getDefault().getLogger().log(Level.WARNING, Messages.JFRLaunch_INVALID_OPTIONS, e);
        }
        return null;
    }
}

