/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ide.launch;

import com.jrockit.mc.common.unit.QuantityConversionException;
import com.jrockit.mc.ide.launch.JFRLaunchPage;
import com.jrockit.mc.ide.launch.LaunchPlugin;
import com.jrockit.mc.ide.launch.Messages;
import com.jrockit.mc.ide.launch.model.JFRLaunchModel;
import java.util.Observable;
import java.util.Observer;
import java.util.logging.Level;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;

public class JFRLaunchConfigurationTab
extends AbstractLaunchConfigurationTab
implements ILaunchConfigurationTab,
Observer {
    private final JFRLaunchModel model = new JFRLaunchModel();
    private JFRLaunchPage jfrLaunchPage;

    public JFRLaunchConfigurationTab() throws Exception {
        this.model.addObserver(this);
        this.jfrLaunchPage = new JFRLaunchPage(this.model);
    }

    public void createControl(Composite parent) {
        this.jfrLaunchPage.createControl(parent);
        this.setControl(this.jfrLaunchPage.getControl());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        try {
            JFRLaunchModel tempModel = new JFRLaunchModel();
            tempModel.updateFromConfiguration((ILaunchConfiguration)configuration);
            tempModel.updateToConfiguration(configuration);
        }
        catch (Exception e) {
            this.setErrorMessage(NLS.bind((String)Messages.JFRLaunch_CONFIG_EXCEPTION, (Object)e.getLocalizedMessage()));
            LaunchPlugin.getDefault().getLogger().log(Level.INFO, NLS.bind((String)Messages.JFRLaunch_CONFIG_EXCEPTION, (Object)e.getLocalizedMessage()), e);
        }
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
        try {
            this.updateTemplate((ILaunchConfiguration)workingCopy);
        }
        catch (Exception e) {
            this.setErrorMessage(NLS.bind((String)Messages.JFRLaunch_CONFIG_EXCEPTION, (Object)e.getLocalizedMessage()));
            LaunchPlugin.getDefault().getLogger().log(Level.INFO, NLS.bind((String)Messages.JFRLaunch_CONFIG_EXCEPTION, (Object)e.getLocalizedMessage()), e);
        }
    }

    private void updateTemplate(ILaunchConfiguration configuration) throws CoreException, QuantityConversionException {
        if (this.model.updateFromJREConfiguration(configuration)) {
            this.jfrLaunchPage.refreshTemplateCombo();
        }
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.updateTemplate(configuration);
            JFRLaunchModel tempModel = new JFRLaunchModel();
            tempModel.updateFromConfiguration(configuration);
            if (this.model.isJFREnabled() != tempModel.isJFREnabled()) {
                this.jfrLaunchPage.setJFREnabled(tempModel.isJFREnabled());
                this.model.setJFREnabled(tempModel.isJFREnabled());
            }
            if (this.model.getAutoOpen() != tempModel.getAutoOpen()) {
                this.jfrLaunchPage.setAutoOpen(tempModel.getAutoOpen());
                this.model.setAutoOpen(tempModel.getAutoOpen());
            }
            if (this.model.isContinuous() != tempModel.isContinuous()) {
                this.jfrLaunchPage.setContinuous(tempModel.isContinuous());
                this.model.setFixedRecording(!tempModel.isContinuous());
            }
            if (!this.model.getDurationString().equals(tempModel.getDurationString())) {
                this.jfrLaunchPage.setDuration(tempModel.getDurationString());
                this.model.setDuration(tempModel.getDurationString());
            }
            if (!this.model.getDelayString().equals(tempModel.getDelayString())) {
                this.jfrLaunchPage.setDelay(tempModel.getDelayString());
                this.model.setDelay(tempModel.getDelayString());
            }
            if (!this.model.getName().equals(tempModel.getName())) {
                this.jfrLaunchPage.setName(tempModel.getName());
                this.model.setName(tempModel.getName());
            }
            if (!this.model.getPath().equals(tempModel.getPath())) {
                this.jfrLaunchPage.setFileName(tempModel.getPath());
                this.model.setPath(tempModel.getPath());
            }
        }
        catch (Exception e) {
            this.setErrorMessage(NLS.bind((String)Messages.JFRLaunch_CONFIG_EXCEPTION, (Object)e.getLocalizedMessage()));
            LaunchPlugin.getDefault().getLogger().log(Level.INFO, NLS.bind((String)Messages.JFRLaunch_CONFIG_EXCEPTION, (Object)e.getLocalizedMessage()), e);
        }
        this.setDirty(false);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (this.isDirty()) {
            this.model.updateToConfiguration(configuration);
            this.setDirty(false);
        }
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        return !this.jfrLaunchPage.isJFREnabled() || this.getErrorMessage() == null;
    }

    public Image getImage() {
        return LaunchPlugin.getDefault().getImage("flr.gif");
    }

    public String getName() {
        return Messages.JFRLaunch_JFR;
    }

    @Override
    public void update(Observable o, Object arg) {
        this.setDirty(true);
        this.setMessage(this.model.getWarningMessage());
        this.setErrorMessage(this.model.checkForErrors());
        this.updateLaunchConfigurationDialog();
    }
}

