/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ext.coherence.tabs;

import com.jrockit.mc.console.ext.coherence.model.CoherenceClusterModel;
import com.jrockit.mc.console.ext.coherence.model.CoherenceMBeanToolkit;
import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.rjmx.ui.internal.CombinedChartSectionPart;
import javax.management.ObjectName;

public final class CoherenceVizualizerUpdateToolkit {
    private CoherenceVizualizerUpdateToolkit() {
        throw new AssertionError((Object)"Toolkit - not to instantiate!");
    }

    public static void updateNodeAttributes(CoherenceClusterModel clusterModel, CombinedChartSectionPart chart, ObjectName objectName, String attributeName) {
        CoherenceVizualizerUpdateToolkit.removeUnavailableNodeAttributes(clusterModel, chart);
        CoherenceVizualizerUpdateToolkit.addNodeAttributes(clusterModel, chart, objectName, attributeName);
    }

    public static void addNodeAttributes(CoherenceClusterModel clusterModel, CombinedChartSectionPart chart, ObjectName objectName, String attributeName) {
        int[] nodeIds = clusterModel.getCurrentNodeIDs();
        if (nodeIds == null) {
            return;
        }
        int[] nArray = nodeIds;
        int n = nodeIds.length;
        int n2 = 0;
        while (n2 < n) {
            int nodeId = nArray[n2];
            ObjectName nodeObjectName = CoherenceMBeanToolkit.extendCoherenceMBeanName(objectName, "nodeId", Integer.toString(nodeId));
            MRI attribute = new MRI(MRI.Type.ATTRIBUTE, nodeObjectName, attributeName);
            chart.add(new MRI[]{attribute});
            ++n2;
        }
    }

    public static void removeUnavailableNodeAttributes(CoherenceClusterModel clusterModel, CombinedChartSectionPart visualizer) {
        MRI[] attributes = visualizer.elements();
        int[] nodeIds = clusterModel.getCurrentNodeIDs();
        MRI[] mRIArray = attributes;
        int n = attributes.length;
        int n2 = 0;
        while (n2 < n) {
            MRI attribute = mRIArray[n2];
            if (CoherenceVizualizerUpdateToolkit.hasNonexistingNodeId(nodeIds, attribute)) {
                visualizer.remove(new MRI[]{attribute});
            }
            ++n2;
        }
    }

    private static boolean hasNonexistingNodeId(int[] nodeIds, MRI attribute) {
        int nodeId;
        ObjectName objectName = attribute.getObjectName();
        if (!CoherenceMBeanToolkit.isCoherenceMBean(objectName)) {
            return false;
        }
        try {
            nodeId = Integer.parseInt(CoherenceMBeanToolkit.getNodeIdProperty(objectName));
        }
        catch (NumberFormatException e) {
            return false;
        }
        int[] nArray = nodeIds;
        int n = nodeIds.length;
        int n2 = 0;
        while (n2 < n) {
            int existingId = nArray[n2];
            if (nodeId == existingId) {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

