/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ext.coherence.tabs;

import com.jrockit.mc.console.ext.coherence.CoherencePlugin;
import com.jrockit.mc.console.ext.coherence.messages.internal.Messages;
import com.jrockit.mc.console.ext.coherence.model.CoherenceNodeModel;
import com.jrockit.mc.console.ext.coherence.tabs.CoherenceNodeContentProvider;
import com.jrockit.mc.ui.fields.FieldTableViewer;
import com.jrockit.mc.ui.misc.DisplayToolkit;
import com.jrockit.mc.ui.model.fields.Field;
import com.jrockit.mc.ui.sections.FieldTableViewerSectionPart;
import java.text.DateFormat;
import java.util.Date;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.IPartSelectionListener;
import org.eclipse.ui.forms.widgets.Section;

public class CoherenceNodeSectionPart
extends FieldTableViewerSectionPart
implements IPartSelectionListener {
    private static Field[] FIELD_PROTOTYPES = new Field[]{CoherenceNodeContentProvider.FIELD_PROPERTY_KEY, CoherenceNodeContentProvider.FIELD_PROPERTY_VALUE};
    private CoherenceNodeModel m_currentNode = null;
    private Observer m_observer = null;
    private final DateFormat m_dateFormat = DateFormat.getTimeInstance(2);

    public CoherenceNodeSectionPart(Composite parent, String sectionIdentifier, IManagedForm form) {
        super(parent, form.getToolkit(), 384, sectionIdentifier, FIELD_PROTOTYPES, CoherencePlugin.getDefault().getMCDialogSettings());
        this.m_observer = this.createObserver();
    }

    private Observer createObserver() {
        return new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                FieldTableViewer tableViewer;
                if (o.equals(CoherenceNodeSectionPart.this.m_currentNode) && arg.equals("Attributes") && (tableViewer = CoherenceNodeSectionPart.this.getTableViewer()) != null) {
                    DisplayToolkit.safeAsyncExec((Widget)tableViewer.getTable(), (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            CoherenceNodeSectionPart.this.updateTableAndTimestamp(CoherenceNodeSectionPart.this.m_currentNode);
                        }
                    });
                }
            }
        };
    }

    public void initialize(IManagedForm form) {
        super.initialize(form);
    }

    private void updateTimeStamp(Object input) {
        if (this.getSection() != null && !this.getSection().isDisposed()) {
            String node = Messages.LABEL_UNKNOWN_NODE_TEXT;
            if (input instanceof CoherenceNodeModel) {
                node = Integer.toString(((CoherenceNodeModel)input).getId());
            }
            this.getSection().setDescription(NLS.bind((String)Messages.SECTION_NODE_DETAILS_DESCRIPTION, (Object)node, (Object)this.m_dateFormat.format(new Date())));
        }
    }

    protected void setupSelectionListeners() {
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
        Object input = ((IStructuredSelection)selection).getFirstElement();
        this.getTableViewer().setInput(input);
        this.updateTableAndTimestamp(input);
        this.changeNodeModel(input);
    }

    private void updateTableAndTimestamp(Object input) {
        this.getTableViewer().refresh();
        this.updateTimeStamp(input);
    }

    private void changeNodeModel(Object input) {
        if (input == this.m_currentNode) {
            return;
        }
        if (this.m_currentNode != null) {
            this.m_currentNode.deleteObserver(this.m_observer);
            this.m_currentNode = null;
        }
        if (!(input instanceof CoherenceNodeModel)) {
            return;
        }
        this.m_currentNode = (CoherenceNodeModel)input;
        ((CoherenceNodeModel)input).addObserver(this.m_observer);
    }

    protected void initializePart() {
        super.initializePart();
        this.getTableViewer().setContentProvider((IContentProvider)new CoherenceNodeContentProvider());
        this.setSortColumn(CoherenceNodeContentProvider.FIELD_PROPERTY_KEY, true);
    }

    protected void initializeSection(Section section) {
        section.setText(Messages.SECTION_NODE_DETAILS_TEXT);
    }
}

