/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ext.coherence.tabs;

import com.jrockit.mc.console.ext.coherence.CoherencePlugin;
import com.jrockit.mc.console.ext.coherence.messages.internal.Messages;
import com.jrockit.mc.console.ext.coherence.model.CoherenceClusterModel;
import com.jrockit.mc.console.ext.coherence.tabs.CoherenceClusterContentProvider;
import com.jrockit.mc.ui.UIPlugin;
import com.jrockit.mc.ui.fields.FieldTableViewer;
import com.jrockit.mc.ui.misc.DisplayToolkit;
import com.jrockit.mc.ui.sections.FieldTableViewerSectionPart;
import com.jrockit.mc.ui.sections.MCSectionPart;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class CoherenceClusterSectionPart
extends FieldTableViewerSectionPart {
    private CoherenceClusterModel m_clusterModel = null;
    private Observer m_observer = null;

    public CoherenceClusterSectionPart(Composite parent, FormToolkit toolkit) {
        super(parent, toolkit, MCSectionPart.getAccessibilityDescriptionStyle(), "coherenceClusterSectionPart", CoherenceClusterContentProvider.FIELD_PROTOTYPES, CoherencePlugin.getDefault().getMCDialogSettings());
    }

    public void dispose() {
        super.dispose();
    }

    public boolean setFormInput(Object input) {
        this.m_clusterModel = (CoherenceClusterModel)input;
        this.m_observer = this.createObserver();
        this.m_clusterModel.addObserver(this.m_observer);
        return true;
    }

    protected void initializeSection(Section section) {
        this.getSection().setText(Messages.SECTION_COHERENCE_NODES_TEXT);
        if (UIPlugin.getDefault().getAccessibilityMode()) {
            section.setDescription(section.getText());
        }
    }

    public void initializePart() {
        super.initializePart();
        this.getTableViewer().setContentProvider((IContentProvider)new CoherenceClusterContentProvider());
        this.getTableViewer().setInput((Object)this.m_clusterModel);
        this.setSortColumn(CoherenceClusterContentProvider.FIELD_NODE_ID, true);
        this.selectFirstElement();
    }

    private Observer createObserver() {
        return new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                FieldTableViewer tableViewer;
                if ((arg.equals("MemberIds") || arg.equals("Attributes")) && (tableViewer = CoherenceClusterSectionPart.this.getTableViewer()) != null) {
                    DisplayToolkit.safeAsyncExec((Widget)tableViewer.getTable(), (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            tableViewer.refresh();
                        }
                    });
                }
            }
        };
    }
}

