/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ext.coherence.tabs;

import com.jrockit.mc.console.ext.coherence.messages.internal.Messages;
import com.jrockit.mc.console.ext.coherence.model.CoherenceClusterModel;
import com.jrockit.mc.console.ext.coherence.model.CoherenceMBeanToolkit;
import com.jrockit.mc.console.ext.coherence.model.CoherenceMBeanType;
import com.jrockit.mc.console.ext.coherence.tabs.CoherenceCachesSectionPart;
import com.jrockit.mc.console.ext.coherence.tabs.CoherenceVizualizerUpdateToolkit;
import com.jrockit.mc.console.ui.actions.ResetToDefaultsAction;
import com.jrockit.mc.console.ui.editor.ConsoleTab;
import com.jrockit.mc.rjmx.ui.internal.CombinedChartSectionPart;
import com.jrockit.mc.ui.misc.DisplayToolkit;
import com.jrockit.mc.ui.misc.MCActionContributionItem;
import com.jrockit.mc.ui.misc.TemporaryMessage;
import com.jrockit.mc.ui.misc.VerticalSectionLayout;
import java.util.Observable;
import java.util.Observer;
import javax.management.ObjectName;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.IMessageManager;
import org.eclipse.ui.forms.editor.IFormPage;

public class CoherenceCachesTab
extends ConsoleTab {
    private static final String REQUEST_AVERAGE_DURATION = "RequestAverageDuration";
    private static final String CHART_ID = "distributedCacheChart";
    private CoherenceClusterModel m_clusterModel;
    private CombinedChartSectionPart m_coherenceChartPart;
    private Observer m_observer;

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        IToolBarManager toolbarManager = managedForm.getForm().getToolBarManager();
        toolbarManager.prependToGroup("MC_TB_GROUP", (IContributionItem)new MCActionContributionItem((IAction)new ResetToDefaultsAction(){

            protected void reset() {
                CoherenceCachesTab.this.m_coherenceChartPart.restoreState(CoherenceCachesTab.this.getDefaultConfig().getChild(CoherenceCachesTab.CHART_ID));
                CoherenceCachesTab.this.rebuildChartContents();
            }
        }));
        toolbarManager.update(true);
        this.m_clusterModel = new CoherenceClusterModel(this.getConnectionHandle());
        this.m_observer = this.createObserver();
        this.m_clusterModel.addObserver(this.m_observer);
        Composite container = managedForm.getForm().getBody();
        container.setLayout((Layout)new VerticalSectionLayout());
        this.m_coherenceChartPart = new CombinedChartSectionPart(container, this.getToolkit(), 322, "", this.getConnectionHandle());
        managedForm.addPart((IFormPart)this.m_coherenceChartPart);
        this.m_coherenceChartPart.restoreState(this.loadState().getChild(CHART_ID));
        CoherenceCachesSectionPart cachesPart = new CoherenceCachesSectionPart(container, this.getToolkit());
        cachesPart.setFormInput(this.m_clusterModel);
        managedForm.addPart((IFormPart)cachesPart);
        this.rebuildChartContents();
        managedForm.reflow(true);
        this.testForCoherenceConnection((IFormPage)this);
    }

    protected boolean saveState(IMemento state) {
        this.m_coherenceChartPart.saveState(state.createChild(CHART_ID));
        return true;
    }

    private void testForCoherenceConnection(IFormPage page) {
        IMessageManager manager = (IMessageManager)page.getAdapter(IMessageManager.class);
        if (manager != null) {
            int thisNodeID;
            TemporaryMessage message = null;
            message = this.m_clusterModel.getCurrentNodeIDs() == null ? new TemporaryMessage(Messages.WARNING_NOT_CONNECTED_TO_COHERENCE_TEXT, 2) : ((thisNodeID = this.m_clusterModel.getThisNodeID()) == -1 ? new TemporaryMessage(Messages.WARNING_UNABLE_TO_DETERMINE_NODE_ID, 2) : new TemporaryMessage(NLS.bind((String)Messages.INFORMATION_NODE_ID_OF_CONNECTION, (Object)thisNodeID), 1));
            message.setDelay(Integer.MAX_VALUE);
            message.show(manager, this.getSite().getShell().getDisplay());
        }
    }

    private Observer createObserver() {
        return new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                if (arg.equals("MemberIds") && CoherenceCachesTab.this.m_coherenceChartPart != null) {
                    DisplayToolkit.safeAsyncExec((Widget)CoherenceCachesTab.this.m_coherenceChartPart.getSection(), (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            CoherenceCachesTab.this.rebuildChartContents();
                        }
                    });
                }
            }
        };
    }

    private void rebuildChartContents() {
        ObjectName serviceMBeanName = CoherenceMBeanToolkit.getCoherenceMBeanName(CoherenceMBeanType.SERVICE, "name", "DistributedCache");
        CoherenceVizualizerUpdateToolkit.updateNodeAttributes(this.m_clusterModel, this.m_coherenceChartPart, serviceMBeanName, REQUEST_AVERAGE_DURATION);
    }
}

