/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ext.coherence.tabs;

import com.jrockit.mc.console.ext.coherence.CoherencePlugin;
import com.jrockit.mc.console.ext.coherence.messages.internal.Messages;
import com.jrockit.mc.console.ext.coherence.model.CoherenceClusterModel;
import com.jrockit.mc.console.ext.coherence.tabs.CoherenceCachesContentProvider;
import com.jrockit.mc.ui.UIPlugin;
import com.jrockit.mc.ui.fields.FieldTreeViewer;
import com.jrockit.mc.ui.misc.DisplayToolkit;
import com.jrockit.mc.ui.sections.FieldTreeViewerSectionPart;
import com.jrockit.mc.ui.sections.MCSectionPart;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class CoherenceCachesSectionPart
extends FieldTreeViewerSectionPart {
    private CoherenceClusterModel m_clusterModel = null;
    private Observer m_observer;

    public CoherenceCachesSectionPart(Composite parent, FormToolkit toolkit) {
        super(parent, toolkit, MCSectionPart.getAccessibilityDescriptionStyle(), "coherenceCachesSectionPart", CoherenceCachesContentProvider.FIELD_PROTOTYPES, CoherencePlugin.getDefault().getMCDialogSettings());
    }

    public void dispose() {
        super.dispose();
    }

    public boolean setFormInput(Object input) {
        this.m_clusterModel = (CoherenceClusterModel)input;
        this.m_observer = this.createObserver();
        this.m_clusterModel.addObserver(this.m_observer);
        return true;
    }

    protected void initializeSection(Section section) {
        this.getSection().setText(Messages.SECTION_COHERENCE_CACHES_TEXT);
        if (UIPlugin.getDefault().getAccessibilityMode()) {
            section.setDescription(section.getText());
        }
    }

    public void initializePart() {
        super.initializePart();
        this.getTreeViewer().setContentProvider((IContentProvider)new CoherenceCachesContentProvider());
        this.getTreeViewer().setInput((Object)this.m_clusterModel);
        this.setSortColumn(CoherenceCachesContentProvider.FIELD_NODE_ID, true);
        this.selectFirstElement();
    }

    private Observer createObserver() {
        return new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                FieldTreeViewer treeViewer;
                if ((arg.equals("Caches") || arg.equals("MemberIds")) && (treeViewer = CoherenceCachesSectionPart.this.getTreeViewer()) != null) {
                    DisplayToolkit.safeAsyncExec((Widget)treeViewer.getTree(), (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            treeViewer.refresh();
                        }
                    });
                }
            }
        };
    }
}

