/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ext.coherence.model;

import com.jrockit.mc.console.ext.coherence.model.CoherenceClusterModel;
import com.jrockit.mc.console.ext.coherence.model.CoherenceMBeanToolkit;
import com.jrockit.mc.console.ext.coherence.model.CoherenceNodeDataModel;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.subscription.IMBeanHelperService;
import com.jrockit.mc.rjmx.subscription.IMRIService;
import com.jrockit.mc.rjmx.subscription.IMRISubscription;
import com.jrockit.mc.rjmx.subscription.IMRIValueListener;
import com.jrockit.mc.rjmx.subscription.ISubscriptionService;
import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.rjmx.subscription.MRIMetaDataToolkit;
import com.jrockit.mc.rjmx.subscription.MRIValueEvent;
import com.jrockit.mc.rjmx.subscription.PolicyFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Set;
import javax.management.ObjectName;

public class CoherenceNodeModel
extends Observable {
    public static final String ATTRIBUTES_NOTIFICATION = "Attributes";
    private static final String ID = "Id";
    private static final String PROCESS_NAME = "ProcessName";
    private static final String MACHINE_NAME = "MachineName";
    private static final String PACKETS_SENT = "PacketsSent";
    private static final String PACKETS_RESENT = "PacketsResent";
    private static final String PUBLISHER_SUCCESS_RATE = "PublisherSuccessRate";
    private static final String PACKETS_RECEIVED = "PacketsReceived";
    private static final String PACKETS_REPEATED = "PacketsRepeated";
    private static final String PACKET_DELIVERY_EFFICIENCY = "PacketDeliveryEfficiency";
    private static final String[] ATTRIBUTE_NAMES = new String[]{"Id", "ProcessName", "MachineName", "PacketsSent", "PacketsResent", "PublisherSuccessRate", "PacketsReceived", "PacketsRepeated", "PacketDeliveryEfficiency"};
    private int m_nodeId = 0;
    private final IConnectionHandle m_connectionHandle;
    private Map<String, Object> m_attributeValues = null;
    private final IMRIValueListener m_valueListener;

    public CoherenceNodeModel(CoherenceClusterModel cluster, IConnectionHandle connectionHandle, int id) {
        this.m_connectionHandle = connectionHandle;
        this.m_valueListener = this.createValueListener();
        this.m_nodeId = id;
        this.setupAttributeSubscriptions();
    }

    private ISubscriptionService getSubscriptionService() {
        return (ISubscriptionService)this.m_connectionHandle.getServiceOrDummy(ISubscriptionService.class);
    }

    private void setupAttributeSubscriptions() {
        ISubscriptionService attributeSubscriptionService = this.getSubscriptionService();
        String[] stringArray = ATTRIBUTE_NAMES;
        int n = ATTRIBUTE_NAMES.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            MRI attr = this.getAttributeDescriptor(name);
            attributeSubscriptionService.addMRIValueListener(attr, this.m_valueListener);
            IMRISubscription subscription = attributeSubscriptionService.getMRISubscription(attr);
            subscription.setUpdatePolicy(PolicyFactory.createSimpleUpdatePolicy((int)3000));
            ++n2;
        }
    }

    private IMRIValueListener createValueListener() {
        return new IMRIValueListener(){

            public void valueChanged(MRIValueEvent event) {
                Object value = event.getValue();
                if (value != null) {
                    CoherenceNodeModel.this.updateAttributeValues();
                }
            }
        };
    }

    public int getId() {
        return this.m_nodeId;
    }

    private Map<String, Object> getAttributeValues() {
        if (this.m_attributeValues == null) {
            this.m_attributeValues = new HashMap<String, Object>();
        }
        return this.m_attributeValues;
    }

    private ObjectName getNodeMBeanName() {
        return CoherenceMBeanToolkit.getNodeMBeanName(Integer.toString(this.getId()));
    }

    private void updateAttributeValues() {
        boolean changed = false;
        String[] stringArray = ATTRIBUTE_NAMES;
        int n = ATTRIBUTE_NAMES.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            Object value = this.getCurrentAttributeValue(this.getAttributeDescriptor(name));
            Object oldValue = this.getAttributeValues().put(name, value);
            changed |= this.hasValueChanged(value, oldValue);
            ++n2;
        }
        if (changed) {
            this.setChanged();
            this.notifyObservers(ATTRIBUTES_NOTIFICATION);
        }
    }

    private boolean hasValueChanged(Object value, Object oldValue) {
        return oldValue == null || !oldValue.equals(value);
    }

    private MRI getAttributeDescriptor(String name) {
        return new MRI(MRI.Type.ATTRIBUTE, this.getNodeMBeanName(), name);
    }

    private Object getCachedAttributeValue(String name) {
        return this.getAttributeValues().get(name);
    }

    private Object getCurrentAttributeValue(MRI descriptor) {
        try {
            IMBeanHelperService helper = (IMBeanHelperService)this.m_connectionHandle.getServiceOrDummy(IMBeanHelperService.class);
            return helper.getAttribute(descriptor).getValue();
        }
        catch (Exception e) {
            return null;
        }
    }

    public Object[] getData() {
        this.updateAttributeValues();
        Object[] result = new Object[ATTRIBUTE_NAMES.length];
        int i = 0;
        while (i < result.length) {
            result[i] = this.getCachedAttributeValue(ATTRIBUTE_NAMES[i]);
            ++i;
        }
        return result;
    }

    public CoherenceNodeDataModel[] getNodeData() {
        IMRIService service = (IMRIService)this.m_connectionHandle.getServiceOrNull(IMRIService.class);
        if (service == null) {
            return new CoherenceNodeDataModel[0];
        }
        Set mris = service.getAttributes();
        HashMap<String, CoherenceNodeDataModel> nodeDataMap = new HashMap<String, CoherenceNodeDataModel>();
        for (MRI descriptor : MRIMetaDataToolkit.filterAttributes((Set)mris)) {
            if (!this.attributeBelongsToNode(descriptor.getObjectName())) continue;
            String attributeName = descriptor.getDataPath();
            Object attributeValue = this.getCurrentAttributeValue(descriptor);
            nodeDataMap.put(attributeName, new CoherenceNodeDataModel(attributeName, attributeValue));
        }
        return nodeDataMap.values().toArray(new CoherenceNodeDataModel[nodeDataMap.size()]);
    }

    private boolean attributeBelongsToNode(ObjectName objectName) {
        return CoherenceMBeanToolkit.isNodeMBean(objectName) && Integer.toString(this.getId()).equals(CoherenceMBeanToolkit.getNodeIdProperty(objectName));
    }

    public boolean equals(Object other) {
        return other instanceof CoherenceNodeModel && ((CoherenceNodeModel)other).getId() == this.getId();
    }

    public int hashCode() {
        return this.getNodeMBeanName().hashCode();
    }

    public void disposeSubscriptions() {
        ISubscriptionService attributeSubscriptionService = this.getSubscriptionService();
        attributeSubscriptionService.removeMRIValueListener(this.m_valueListener);
    }
}

