/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ext.coherence.model;

import com.jrockit.mc.console.ext.coherence.messages.internal.Messages;
import com.jrockit.mc.console.ext.coherence.model.CoherenceMBeanToolkit;
import com.jrockit.mc.console.ext.coherence.model.CoherenceMBeanType;
import com.jrockit.mc.rjmx.subscription.IMRIMetaDataProviderService;
import com.jrockit.mc.rjmx.subscription.IMRIMetaDataService;
import com.jrockit.mc.rjmx.subscription.MRI;
import java.util.Hashtable;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.eclipse.osgi.util.NLS;

public final class CoherenceMRIMetaDataProviderService
implements IMRIMetaDataProviderService {
    private String getCoherenceAttributeDisplayName(IMRIMetaDataService metaDataService, MRI descriptor) {
        ObjectName objectName = descriptor.getObjectName();
        if (CoherenceMBeanToolkit.isCoherenceType(objectName, CoherenceMBeanType.PLATFORM)) {
            return this.buildPlatformDisplayName(metaDataService, descriptor);
        }
        if (CoherenceMBeanToolkit.isCoherenceType(objectName, CoherenceMBeanType.SERVICE)) {
            return this.buildServiceDisplayName(descriptor);
        }
        return this.buildCoherenceDisplayName(descriptor);
    }

    private MRI createPlatformDescriptor(MRI descriptor) {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ObjectName objectName = descriptor.getObjectName();
        properties.put("type", CoherenceMBeanToolkit.getSubTypeProperty(objectName));
        String name = CoherenceMBeanToolkit.getNameProperty(objectName);
        if (name != null) {
            properties.put("name", name);
        }
        try {
            return new MRI(MRI.Type.ATTRIBUTE, new ObjectName(CoherenceMBeanToolkit.getDomainProperty(objectName), properties), descriptor.getDataPath());
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private String buildPlatformDisplayName(IMRIMetaDataService metaDataService, MRI descriptor) {
        MRI platformDescriptor = this.createPlatformDescriptor(descriptor);
        Object attributeName = metaDataService.getMetaData(platformDescriptor, "DisplayName");
        if (attributeName == null) {
            attributeName = descriptor.getDataPath();
        }
        String nodeId = CoherenceMBeanToolkit.getNodeIdProperty(descriptor.getObjectName());
        return NLS.bind((String)Messages.LABEL_ATTRIBUTE_NODE_TEXT, (Object)nodeId, (Object)attributeName);
    }

    private String buildServiceDisplayName(MRI descriptor) {
        String nodeId = CoherenceMBeanToolkit.getNodeIdProperty(descriptor.getObjectName());
        String cacheName = CoherenceMBeanToolkit.getNameProperty(descriptor.getObjectName());
        return NLS.bind((String)Messages.LABEL_ATTRIBUTE_CACHE_NODE_TEXT, (Object[])new Object[]{nodeId, descriptor.getDataPath(), cacheName});
    }

    private String buildCoherenceDisplayName(MRI descriptor) {
        String nodeId = CoherenceMBeanToolkit.getNodeIdProperty(descriptor.getObjectName());
        return NLS.bind((String)Messages.LABEL_ATTRIBUTE_NODE_TEXT, (Object)nodeId, (Object)descriptor.getDataPath());
    }

    private Object getPlatformMetaData(IMRIMetaDataService metaDataService, MRI descriptor, String dataKey) {
        return metaDataService.getMetaData(this.createPlatformDescriptor(descriptor), dataKey);
    }

    public Object getMetaData(IMRIMetaDataService metaDataService, MRI mri, String dataKey) {
        if ("DisplayName".equals(dataKey) && CoherenceMBeanToolkit.isCoherenceMBean(mri.getObjectName()) && CoherenceMBeanToolkit.getNodeIdProperty(mri.getObjectName()) != null) {
            return this.getCoherenceAttributeDisplayName(metaDataService, mri);
        }
        if (("Description".equals(dataKey) || "UnitString".equals(dataKey)) && CoherenceMBeanToolkit.isCoherenceMBean(mri.getObjectName()) && CoherenceMBeanToolkit.isCoherenceType(mri.getObjectName(), CoherenceMBeanType.PLATFORM)) {
            return this.getPlatformMetaData(metaDataService, mri, dataKey);
        }
        return null;
    }
}

