/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ext.coherence.model;

import com.jrockit.mc.console.ext.coherence.model.CoherenceMBeanType;
import java.util.Hashtable;
import java.util.Map;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public final class CoherenceMBeanToolkit {
    private static final String DOMAIN_COHERENCE = "Coherence";
    public static final String PROPERTY_DOMAIN = "Domain";
    public static final String PROPERTY_NAME = "name";
    public static final String PROPERTY_NODE_ID = "nodeId";
    public static final String PROPERTY_SUB_TYPE = "subType";
    public static final String PROPERTY_TYPE = "type";

    private CoherenceMBeanToolkit() {
        throw new AssertionError((Object)"Toolkit - not to instantiate!");
    }

    public static ObjectName getCoherenceMBeanName(CoherenceMBeanType type, String ... values) {
        Hashtable<String, String> properties = new Hashtable<String, String>(values.length / 2 + 1);
        properties.put(PROPERTY_TYPE, type.getType());
        int i = 0;
        while (i < values.length) {
            properties.put(values[i], values[i + 1]);
            i += 2;
        }
        return CoherenceMBeanToolkit.createCoherenceMBeanName(properties);
    }

    private static ObjectName createCoherenceMBeanName(Map<String, String> properties) {
        try {
            return new ObjectName(DOMAIN_COHERENCE, new Hashtable<String, String>(properties));
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static ObjectName extendCoherenceMBeanName(ObjectName objectName, String property, String value) {
        Hashtable<String, String> properties = objectName.getKeyPropertyList();
        properties.put(property, value);
        return CoherenceMBeanToolkit.createCoherenceMBeanName(properties);
    }

    public static ObjectName getClusterMBeanName() {
        return CoherenceMBeanToolkit.getCoherenceMBeanName(CoherenceMBeanType.CLUSTER, new String[0]);
    }

    public static ObjectName getNodeMBeanName(String nodeId) {
        return CoherenceMBeanToolkit.getCoherenceMBeanName(CoherenceMBeanType.NODE, PROPERTY_NODE_ID, nodeId);
    }

    public static ObjectName getServiceMBeanName(String nodeId, String cacheName) {
        return CoherenceMBeanToolkit.getCoherenceMBeanName(CoherenceMBeanType.SERVICE, PROPERTY_NODE_ID, nodeId, PROPERTY_NAME, cacheName);
    }

    public static String getDomainProperty(ObjectName objectName) {
        return objectName.getKeyProperty(PROPERTY_DOMAIN);
    }

    public static String getNameProperty(ObjectName objectName) {
        return objectName.getKeyProperty(PROPERTY_NAME);
    }

    public static String getNodeIdProperty(ObjectName objectName) {
        return objectName.getKeyProperty(PROPERTY_NODE_ID);
    }

    public static String getSubTypeProperty(ObjectName objectName) {
        return objectName.getKeyProperty(PROPERTY_SUB_TYPE);
    }

    private static String getTypeProperty(ObjectName objectName) {
        return objectName.getKeyProperty(PROPERTY_TYPE);
    }

    public static boolean isCoherenceType(ObjectName objectName, CoherenceMBeanType type) {
        return type.getType().equals(CoherenceMBeanToolkit.getTypeProperty(objectName));
    }

    public static boolean isCoherenceMBean(ObjectName objectName) {
        return objectName.getDomain().equals(DOMAIN_COHERENCE);
    }

    private static boolean isCoherenceMBean(ObjectName objectName, CoherenceMBeanType type) {
        return CoherenceMBeanToolkit.isCoherenceMBean(objectName) && CoherenceMBeanToolkit.isCoherenceType(objectName, type);
    }

    public static boolean isNodeMBean(ObjectName objectName) {
        return CoherenceMBeanToolkit.isCoherenceMBean(objectName, CoherenceMBeanType.NODE);
    }

    public static boolean isServiceMBean(ObjectName objectName) {
        return CoherenceMBeanToolkit.isCoherenceMBean(objectName, CoherenceMBeanType.SERVICE);
    }
}

