/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ext.coherence.model;

import com.jrockit.mc.console.ext.coherence.model.CoherenceCacheModel;
import com.jrockit.mc.console.ext.coherence.model.CoherenceMBeanToolkit;
import com.jrockit.mc.console.ext.coherence.model.CoherenceNodeModel;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.subscription.IMBeanHelperService;
import com.jrockit.mc.rjmx.subscription.IMRIService;
import com.jrockit.mc.rjmx.subscription.IMRISubscription;
import com.jrockit.mc.rjmx.subscription.IMRIValueListener;
import com.jrockit.mc.rjmx.subscription.ISubscriptionService;
import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.rjmx.subscription.MRIMetaDataToolkit;
import com.jrockit.mc.rjmx.subscription.MRIValueEvent;
import com.jrockit.mc.rjmx.subscription.PolicyFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import javax.management.JMException;

public class CoherenceClusterModel
extends Observable {
    public static final String MEMBER_IDS_NOTIFICATION = "MemberIds";
    private static final String ATTRIBUTE_LOCAL_MEMBER_ID = "LocalMemberId";
    private static final String ATTRIBUTE_MEMBER_IDS = "MemberIds";
    private static final MRI CLUSTER_NODES_ATTRIBUTE = new MRI(MRI.Type.ATTRIBUTE, CoherenceMBeanToolkit.getClusterMBeanName(), "MemberIds");
    private static final MRI CLUSTER_NODE_ATTRIBUTE = new MRI(MRI.Type.ATTRIBUTE, CoherenceMBeanToolkit.getClusterMBeanName(), "LocalMemberId");
    private final IConnectionHandle m_connectionHandle;
    private int[] m_currentNodeIDs;
    private final Observer m_nodeObserver;
    private final Map<Integer, CoherenceNodeModel> m_currentNodes;
    private final Map<String, CoherenceCacheModel> m_currentCaches;

    public CoherenceClusterModel(IConnectionHandle connectionHandle) {
        this.m_connectionHandle = connectionHandle;
        this.m_nodeObserver = this.createNodeObserver();
        this.m_currentNodes = new HashMap<Integer, CoherenceNodeModel>();
        this.m_currentCaches = new HashMap<String, CoherenceCacheModel>();
        this.setupClusterNodesSubscription(this.m_connectionHandle);
    }

    private Observer createNodeObserver() {
        return new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                if (arg.equals("Attributes")) {
                    CoherenceClusterModel.this.setChanged();
                    CoherenceClusterModel.this.notifyObservers("Attributes");
                }
            }
        };
    }

    private void setupClusterNodesSubscription(IConnectionHandle connectionHandle) {
        ISubscriptionService attributeSubscriptionService = (ISubscriptionService)this.m_connectionHandle.getServiceOrDummy(ISubscriptionService.class);
        IMBeanHelperService helper = (IMBeanHelperService)this.m_connectionHandle.getServiceOrDummy(IMBeanHelperService.class);
        attributeSubscriptionService.addMRIValueListener(CLUSTER_NODES_ATTRIBUTE, new IMRIValueListener(){

            public void valueChanged(MRIValueEvent event) {
                Object value = event.getValue();
                if (value != null) {
                    CoherenceClusterModel.this.setCurrentNodeIDs(value);
                }
            }
        });
        IMRISubscription subscription = attributeSubscriptionService.getMRISubscription(CLUSTER_NODES_ATTRIBUTE);
        subscription.setUpdatePolicy(PolicyFactory.createSimpleUpdatePolicy((int)5000));
        try {
            this.setCurrentNodeIDs(helper.getAttribute(CLUSTER_NODES_ATTRIBUTE).getValue());
        }
        catch (IOException e) {
            this.setCurrentNodeIDs(null);
        }
        catch (JMException e) {
            this.setCurrentNodeIDs(null);
        }
    }

    private void setCurrentNodeIDs(Object nodes) {
        if (nodes instanceof int[]) {
            if (this.m_currentNodeIDs == null || !Arrays.equals(this.m_currentNodeIDs, (int[])nodes)) {
                this.m_currentNodeIDs = (int[])nodes;
                this.purgeRemovedNodes(this.findRemovedNodes());
                this.insertAddedNodes(this.findAddedNodes());
                this.setChanged();
                this.notifyObservers("MemberIds");
            }
        } else {
            this.purgeRemovedNodes(this.asList(this.m_currentNodeIDs));
            this.m_currentNodeIDs = null;
            this.setChanged();
            this.notifyObservers("MemberIds");
        }
    }

    public int[] getCurrentNodeIDs() {
        return this.m_currentNodeIDs;
    }

    private Iterable<Integer> findAddedNodes() {
        return this.setDifference(this.asList(this.m_currentNodeIDs), this.getNodes().keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Integer, CoherenceNodeModel> getNodes() {
        Map<Integer, CoherenceNodeModel> map = this.m_currentNodes;
        synchronized (map) {
            return new HashMap<Integer, CoherenceNodeModel>(this.m_currentNodes);
        }
    }

    private List<Integer> asList(int[] ids) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        int[] nArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            Integer i = nArray[n2];
            list.add(i);
            ++n2;
        }
        return list;
    }

    private Iterable<Integer> findRemovedNodes() {
        return this.setDifference(this.getNodes().keySet(), this.asList(this.m_currentNodeIDs));
    }

    private <T> Iterable<T> setDifference(Collection<T> set, Collection<T> difference) {
        ArrayList<T> setDifference = new ArrayList<T>(set);
        setDifference.removeAll(difference);
        return setDifference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgeRemovedNodes(Iterable<Integer> purgeIDs) {
        for (Integer id : purgeIDs) {
            CoherenceNodeModel nodeModel;
            Map<Integer, CoherenceNodeModel> map = this.m_currentNodes;
            synchronized (map) {
                nodeModel = this.m_currentNodes.remove(id);
            }
            nodeModel.deleteObserver(this.m_nodeObserver);
            nodeModel.disposeSubscriptions();
        }
    }

    private void buildCurrentNodes() {
        int[] intNodes = this.getCurrentNodeIDs();
        if (intNodes != null && this.m_currentNodes.isEmpty()) {
            this.insertAddedNodes(this.asList(intNodes));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertAddedNodes(Iterable<Integer> addedIDs) {
        for (Integer id : addedIDs) {
            CoherenceNodeModel nodeModel = new CoherenceNodeModel(this, this.m_connectionHandle, id);
            nodeModel.addObserver(this.m_nodeObserver);
            Map<Integer, CoherenceNodeModel> map = this.m_currentNodes;
            synchronized (map) {
                this.m_currentNodes.put(id, nodeModel);
            }
        }
    }

    private void buildCurrentCaches() {
        HashMap<String, List<String>> cacheMap = new HashMap<String, List<String>>();
        IMRIService service = (IMRIService)this.m_connectionHandle.getServiceOrNull(IMRIService.class);
        if (service != null) {
            for (MRI descriptor : MRIMetaDataToolkit.filterAttributes((Set)service.getAttributes())) {
                this.getCacheInformation(cacheMap, descriptor);
            }
        }
        this.buildCacheModels(cacheMap);
    }

    private void getCacheInformation(Map<String, List<String>> cacheMap, MRI descriptor) {
        if (CoherenceMBeanToolkit.isServiceMBean(descriptor.getObjectName())) {
            String cacheName = CoherenceMBeanToolkit.getNameProperty(descriptor.getObjectName());
            String nodeName = CoherenceMBeanToolkit.getNodeIdProperty(descriptor.getObjectName());
            List<String> nodeList = this.getNodeList(cacheMap, cacheName);
            if (!nodeList.contains(nodeName)) {
                nodeList.add(nodeName);
            }
        }
    }

    private List<String> getNodeList(Map<String, List<String>> cacheMap, String cacheName) {
        List<String> nodeList = cacheMap.get(cacheName);
        if (nodeList == null) {
            nodeList = new ArrayList<String>();
            cacheMap.put(cacheName, nodeList);
        }
        return nodeList;
    }

    private void buildCacheModels(Map<String, List<String>> cacheInfoMap) {
        this.pruneRemovedCacheModels(this.findRemovedCaches(cacheInfoMap.keySet()));
        for (Map.Entry<String, List<String>> entry : cacheInfoMap.entrySet()) {
            this.updateCacheModel(entry.getKey(), entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pruneRemovedCacheModels(Iterable<String> removedCaches) {
        for (String cacheName : removedCaches) {
            CoherenceCacheModel model;
            Map<String, CoherenceCacheModel> map = this.m_currentCaches;
            synchronized (map) {
                model = this.m_currentCaches.remove(cacheName);
            }
            model.disposeSubscriptions();
        }
    }

    private Iterable<String> findRemovedCaches(Collection<String> cacheNames) {
        return this.setDifference(this.getCaches().keySet(), cacheNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCacheModel(String cacheName, List<String> nodesIds) {
        CoherenceCacheModel model;
        Map<String, CoherenceCacheModel> map = this.m_currentCaches;
        synchronized (map) {
            model = this.m_currentCaches.get(cacheName);
        }
        if (model == null) {
            model = new CoherenceCacheModel(this.m_connectionHandle, cacheName, nodesIds);
            map = this.m_currentCaches;
            synchronized (map) {
                this.m_currentCaches.put(cacheName, model);
            }
        } else {
            model.updateNodeIds(nodesIds);
        }
    }

    public CoherenceNodeModel[] getCurrentNodes() {
        this.buildCurrentNodes();
        Map<Integer, CoherenceNodeModel> currentNodes = this.getNodes();
        return currentNodes.values().toArray(new CoherenceNodeModel[currentNodes.size()]);
    }

    public CoherenceCacheModel[] getCurrentCaches() {
        this.buildCurrentCaches();
        Map<String, CoherenceCacheModel> currentCaches = this.getCaches();
        return currentCaches.values().toArray(new CoherenceCacheModel[currentCaches.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, CoherenceCacheModel> getCaches() {
        Map<String, CoherenceCacheModel> map = this.m_currentCaches;
        synchronized (map) {
            return this.m_currentCaches;
        }
    }

    public int getThisNodeID() {
        try {
            Object value = ((IMBeanHelperService)this.m_connectionHandle.getServiceOrNull(IMBeanHelperService.class)).getAttribute(CLUSTER_NODE_ATTRIBUTE).getValue();
            if (value instanceof Number) {
                return ((Number)value).intValue();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1;
    }
}

