/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ext.coherence.model;

import com.jrockit.mc.console.ext.coherence.messages.internal.Messages;
import com.jrockit.mc.console.ext.coherence.model.CoherenceMBeanToolkit;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.subscription.IMBeanHelperService;
import com.jrockit.mc.rjmx.subscription.IMRISubscription;
import com.jrockit.mc.rjmx.subscription.IMRIValueListener;
import com.jrockit.mc.rjmx.subscription.ISubscriptionService;
import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.rjmx.subscription.MRIValueEvent;
import com.jrockit.mc.rjmx.subscription.PolicyFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import javax.management.JMException;
import org.eclipse.osgi.util.NLS;

public class CoherenceCacheModel
extends Observable {
    public static final String CACHES_NOTIFICATION = "Caches";
    private static final String DISTRIBUTED_CACHE_NAME = "DistributedCache";
    private static final String OWNED_PARTITIONS_PRIMARY = "OwnedPartitionsPrimary";
    private static final String OWNED_PARTITIONS_BACKUP = "OwnedPartitionsBackup";
    private static final String REQUEST_AVERAGE_DURATION = "RequestAverageDuration";
    private static final String REQUEST_PENDING_COUNT = "RequestPendingCount";
    private static final String TASK_BACK_LOG = "TaskBacklog";
    private static final String TASK_HUNG_COUNT = "TaskHungCount";
    private static final String[] ATTRIBUTE_NAMES = new String[]{"OwnedPartitionsPrimary", "OwnedPartitionsBackup", "RequestAverageDuration", "RequestPendingCount", "TaskBacklog", "TaskHungCount"};
    private final List<String> m_nodeIds;
    private final Map<String, IMRIValueListener> m_valueListeners;
    private final String m_cacheName;
    private final IConnectionHandle m_connectionHandle;
    private Map<String, Object> m_attributeValues;
    private Map<String, Object> m_aggregatedAttributeValues;

    public CoherenceCacheModel(IConnectionHandle connectionHandle, String cacheName, List<String> nodeIds) {
        this.m_connectionHandle = connectionHandle;
        this.m_cacheName = cacheName;
        this.m_nodeIds = nodeIds;
        this.m_valueListeners = new HashMap<String, IMRIValueListener>();
        this.setupAttributeSubscriptions();
    }

    private ISubscriptionService getSubscriptionService() {
        return (ISubscriptionService)this.m_connectionHandle.getServiceOrDummy(ISubscriptionService.class);
    }

    private void setupAttributeSubscriptions() {
        ISubscriptionService attributeSubscriptionService = this.getSubscriptionService();
        for (String nodeId : this.getNodeIds()) {
            this.setupNodeAttributeSubscriptions(attributeSubscriptionService, nodeId);
        }
    }

    private void setupNodeAttributeSubscriptions(ISubscriptionService attributeSubscriptionService, String nodeId) {
        String[] stringArray = ATTRIBUTE_NAMES;
        int n = ATTRIBUTE_NAMES.length;
        int n2 = 0;
        while (n2 < n) {
            String attributeName = stringArray[n2];
            MRI attr = this.getAttributeDescriptor(nodeId, attributeName);
            attributeSubscriptionService.addMRIValueListener(attr, this.getValueListener(nodeId));
            IMRISubscription subscription = attributeSubscriptionService.getMRISubscription(attr);
            subscription.setUpdatePolicy(PolicyFactory.createSimpleUpdatePolicy((int)3000));
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IMRIValueListener getValueListener(String nodeId) {
        IMRIValueListener listener;
        Map<String, IMRIValueListener> map = this.m_valueListeners;
        synchronized (map) {
            listener = this.m_valueListeners.get(nodeId);
        }
        if (listener == null) {
            listener = this.createValueListener();
            map = this.m_valueListeners;
            synchronized (map) {
                this.m_valueListeners.put(nodeId, listener);
            }
        }
        return listener;
    }

    private IMRIValueListener createValueListener() {
        return new IMRIValueListener(){

            public void valueChanged(MRIValueEvent event) {
                Object value = event.getValue();
                if (value != null) {
                    CoherenceCacheModel.this.updateAttributeValues();
                }
            }
        };
    }

    public boolean equals(Object o) {
        if (!(o instanceof CoherenceCacheModel)) {
            return false;
        }
        String thatName = ((CoherenceCacheModel)o).getName();
        if (this.getName() == null) {
            return thatName == null;
        }
        return this.getName().equals(thatName);
    }

    public int hashCode() {
        if (this.getName() == null) {
            return 0;
        }
        return this.getName().hashCode();
    }

    public String getName() {
        return this.m_cacheName;
    }

    private Map<String, Object> getAttributeValues() {
        if (this.m_attributeValues == null) {
            this.m_attributeValues = new HashMap<String, Object>();
        }
        return this.m_attributeValues;
    }

    private Map<String, Object> getAggregatedAttributeValues() {
        if (this.m_aggregatedAttributeValues == null) {
            this.m_aggregatedAttributeValues = new HashMap<String, Object>();
        }
        return this.m_aggregatedAttributeValues;
    }

    private void updateAttributeValues() {
        this.getAggregatedAttributeValues();
        boolean changed = false;
        String[] stringArray = ATTRIBUTE_NAMES;
        int n = ATTRIBUTE_NAMES.length;
        int n2 = 0;
        while (n2 < n) {
            String attributeName = stringArray[n2];
            changed |= this.updateAttributeValue(attributeName);
            ++n2;
        }
        if (changed) {
            this.setChanged();
            this.notifyObservers(CACHES_NOTIFICATION);
        }
    }

    private boolean updateAttributeValue(String attributeName) {
        boolean changed = false;
        double sum = 0.0;
        int count = 0;
        for (String nodeId : this.getNodeIds()) {
            Object value = this.getCurrentAttributeValue(this.getAttributeDescriptor(nodeId, attributeName));
            Object oldValue = this.getAttributeValues().put(this.getAttributeId(nodeId, attributeName), value);
            changed |= this.hasValueChanged(value, oldValue);
            if (!(value instanceof Number)) continue;
            sum += ((Number)value).doubleValue();
            ++count;
        }
        if (count > 0) {
            double average = sum / (double)count;
            this.getAggregatedAttributeValues().put(attributeName, average);
        }
        return changed;
    }

    private boolean hasValueChanged(Object value, Object oldValue) {
        return oldValue == null || !oldValue.equals(value);
    }

    private Object getCurrentAttributeValue(MRI descriptor) {
        try {
            IMBeanHelperService helper = (IMBeanHelperService)this.m_connectionHandle.getServiceOrNull(IMBeanHelperService.class);
            return helper != null ? helper.getAttribute(descriptor).getValue() : null;
        }
        catch (IOException e) {
            return null;
        }
        catch (JMException e) {
            return null;
        }
    }

    private Object getCachedAttributeValue(String nodeId, String attributeName) {
        if (this.hasNoPartionValue(attributeName)) {
            return "";
        }
        return this.getAttributeValues().get(this.getAttributeId(nodeId, attributeName));
    }

    private boolean hasNoPartionValue(String attributeName) {
        return (attributeName.equals(OWNED_PARTITIONS_PRIMARY) || attributeName.equals(OWNED_PARTITIONS_BACKUP)) && !this.getName().equals(DISTRIBUTED_CACHE_NAME);
    }

    private Object[] getCachedNodeAttributeValues(String nodeId) {
        Object[] values = new Object[ATTRIBUTE_NAMES.length + 1];
        int i = 1;
        values[0] = NLS.bind((String)Messages.LABEL_NODE_TEXT, (Object)nodeId);
        String[] stringArray = ATTRIBUTE_NAMES;
        int n = ATTRIBUTE_NAMES.length;
        int n2 = 0;
        while (n2 < n) {
            String attributeName = stringArray[n2];
            values[i] = this.getCachedAttributeValue(nodeId, attributeName);
            ++i;
            ++n2;
        }
        return values;
    }

    private String getAttributeId(String nodeId, String attributeName) {
        return String.valueOf(attributeName) + ':' + nodeId;
    }

    private Object getAggregatedAttributeValue(String name) {
        if (this.hasNoPartionValue(name)) {
            return "";
        }
        return this.getAggregatedAttributeValues().get(name);
    }

    private MRI getAttributeDescriptor(String nodeId, String attributeName) {
        return new MRI(MRI.Type.ATTRIBUTE, CoherenceMBeanToolkit.getServiceMBeanName(nodeId, this.m_cacheName), attributeName);
    }

    public Object[] getChildren() {
        Collection<String> nodeIds = this.getNodeIds();
        ArrayList<Object[]> children = new ArrayList<Object[]>();
        for (String nodeId : nodeIds) {
            children.add(this.getCachedNodeAttributeValues(nodeId));
        }
        return children.toArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<String> getNodeIds() {
        List<String> list = this.m_nodeIds;
        synchronized (list) {
            return new ArrayList<String>(this.m_nodeIds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasChildren() {
        List<String> list = this.m_nodeIds;
        synchronized (list) {
            return this.m_nodeIds.size() > 0;
        }
    }

    public Object[] getData() {
        this.updateAttributeValues();
        int i = 1;
        Object[] result = new Object[ATTRIBUTE_NAMES.length + 1];
        result[0] = NLS.bind((String)Messages.LABEL_CACHE_AVERAGE_TEXT, (Object)this.m_cacheName);
        String[] stringArray = ATTRIBUTE_NAMES;
        int n = ATTRIBUTE_NAMES.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            result[i] = this.getAggregatedAttributeValue(name);
            ++i;
            ++n2;
        }
        return result;
    }

    public void updateNodeIds(List<String> nodeIds) {
        this.purgeRemovedNodes(this.findRemovedNodes(nodeIds));
        this.insertAddedNodes(this.findAddedNodes(nodeIds));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertAddedNodes(Iterable<String> addedNodes) {
        ISubscriptionService attributeSubscriptionService = this.getSubscriptionService();
        for (String nodeId : addedNodes) {
            List<String> list = this.m_nodeIds;
            synchronized (list) {
                this.m_nodeIds.add(nodeId);
            }
            this.setupNodeAttributeSubscriptions(attributeSubscriptionService, nodeId);
        }
    }

    private Iterable<String> findAddedNodes(List<String> nodeIds) {
        return this.setDifference(nodeIds, this.getNodeIds());
    }

    private <T> Iterable<T> setDifference(Collection<T> set, Collection<T> difference) {
        ArrayList<T> setDifference = new ArrayList<T>(set);
        setDifference.removeAll(difference);
        return setDifference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgeRemovedNodes(Iterable<String> removedNodes) {
        ISubscriptionService attributeSubscriptionService = this.getSubscriptionService();
        for (String nodeId : removedNodes) {
            IMRIValueListener valueListener;
            List<String> list = this.m_nodeIds;
            synchronized (list) {
                this.m_nodeIds.remove(nodeId);
            }
            Map<String, IMRIValueListener> map = this.m_valueListeners;
            synchronized (map) {
                valueListener = this.m_valueListeners.remove(nodeId);
            }
            attributeSubscriptionService.removeMRIValueListener(valueListener);
        }
    }

    private Iterable<String> findRemovedNodes(List<String> nodeIds) {
        return this.setDifference(this.getNodeIds(), nodeIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disposeSubscriptions() {
        ISubscriptionService attributeSubscriptionService = this.getSubscriptionService();
        Map<String, IMRIValueListener> map = this.m_valueListeners;
        synchronized (map) {
            for (IMRIValueListener listener : this.m_valueListeners.values()) {
                attributeSubscriptionService.removeMRIValueListener(listener);
            }
        }
    }
}

