/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.jconsole.tabs;

import com.jrockit.mc.console.jconsole.Activator;
import com.jrockit.mc.console.jconsole.JConsolePluginLoader;
import com.jrockit.mc.console.jconsole.MissionControlContext;
import com.jrockit.mc.console.jconsole.tabs.Messages;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.sun.tools.jconsole.JConsolePlugin;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingWorker;
import org.eclipse.osgi.util.NLS;

public class JConsolePluginTabbedPane
extends JTabbedPane {
    private final List<JConsolePlugin> plugins = new ArrayList<JConsolePlugin>();
    private final Map<JConsolePlugin, SwingWorker<?, ?>> swingWorkers = new HashMap();
    private volatile boolean disposeTimerTask = false;
    private final MissionControlContext ctx;

    public JConsolePluginTabbedPane(IConnectionHandle connectionHandle) {
        super(1);
        this.ctx = new MissionControlContext(connectionHandle);
        this.setBackground(Color.WHITE);
        this.setForeground(Color.BLACK);
        try {
            File pluginDir = Activator.getJConsolePluginDir();
            this.addFromExtensionPoints();
            this.addFromPluginsFolder(pluginDir);
            if (this.plugins.isEmpty()) {
                this.addAppropriateErrorTab(pluginDir);
                return;
            }
            for (JConsolePlugin plugin : this.plugins) {
                plugin.setContext(this.ctx);
                for (Map.Entry<String, JPanel> e : plugin.getTabs().entrySet()) {
                    this.add(e.getKey(), e.getValue());
                }
            }
        }
        catch (Exception e) {
            this.addErrorTab(Messages.JConsolePluginTabbedPane_TAB_TITLE_COULD_NOT_CREATE_PLUGINS, e);
        }
        this.startUpdateThread();
    }

    private void addAppropriateErrorTab(File pluginDir) {
        if (pluginDir.toString().equals("")) {
            this.addErrorTab(Messages.JConsolePluginTabbedPane_TAB_TITLE_COULD_NOT_CREATE_PLUGINS, Messages.JConsolePluginTabbedPane_ERROR_MESSAGE_MESSAGE_PREFERENCE_NOT_SET);
            return;
        }
        if (!pluginDir.exists() || !pluginDir.isDirectory()) {
            this.addErrorTab(Messages.JConsolePluginTabbedPane_TAB_TITLE_COULD_NOT_CREATE_PLUGINS, NLS.bind((String)Messages.JConsolePluginTabbedPane_ERROR_MESSAGE_DIRECTORY_DOES_NOT_EXIST, (Object)pluginDir));
            return;
        }
        this.addErrorTab(Messages.JConsolePluginTabbedPane_TAB_TITLE_NO_PLUGINS, NLS.bind((String)Messages.JConsolePluginTabbedPane_ERROR_MESSAGE_COULD_NOT_FIND_ANY_PLUGINS, (Object)pluginDir));
    }

    private void addFromExtensionPoints() {
        this.plugins.addAll(JConsolePluginLoader.getExtensionPlugins());
    }

    public void addFromPluginsFolder(File pluginDir) throws IOException {
        if (pluginDir.exists() && pluginDir.isDirectory()) {
            this.plugins.addAll(JConsolePluginLoader.getPlugins(Activator.getJConsolePluginDir()));
        } else {
            Activator.getLogger().warning(String.format("Could not find a properly configured JConsole plug-in folder (%s). Please set up the plug-in folder in the preferences.", pluginDir.toString()));
        }
    }

    private void addErrorTab(String title, String message) {
        JPanel p = new JPanel(new BorderLayout());
        String labelMessage = NLS.bind((String)Messages.JConsolePluginTabbedPane_ERROR_MESSAGE_COULD_NOT_CREATE_PLUGIN_TAB_HTML, (Object)message);
        JLabel l = new JLabel(labelMessage);
        l.setBackground(Color.WHITE);
        l.setForeground(Color.BLACK);
        l.setOpaque(true);
        p.add((Component)l, "Center");
        Activator.getLogger().log(Level.WARNING, NLS.bind((String)Messages.JConsolePluginTabbedPane_ERROR_MESSAGE_COULD_NOT_CREATE_PLUGIN_TAB, (Object)message));
        this.add(title, p);
    }

    private void startUpdateThread() {
        final Timer t = new Timer();
        t.schedule(new TimerTask(){

            @Override
            public void run() {
                if (JConsolePluginTabbedPane.this.disposeTimerTask) {
                    t.cancel();
                    JConsolePluginTabbedPane.this.ctx.dispose();
                    return;
                }
                for (JConsolePlugin p : JConsolePluginTabbedPane.this.plugins) {
                    SwingWorker<?, ?> sw = p.newSwingWorker();
                    SwingWorker prevSW = (SwingWorker)JConsolePluginTabbedPane.this.swingWorkers.get(p);
                    if (prevSW != null && !prevSW.isDone() || sw != null && sw.getState() != SwingWorker.StateValue.PENDING) continue;
                    JConsolePluginTabbedPane.this.swingWorkers.put(p, sw);
                    if (sw == null) continue;
                    sw.execute();
                }
            }
        }, 1000L, 1000L);
    }

    private void addErrorTab(String title, Exception e) {
        this.addErrorTab(title, e.getMessage());
    }

    void dispose() {
        this.disposeTimerTask = true;
    }
}

