/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.jconsole;

import com.jrockit.mc.console.jconsole.Activator;
import com.jrockit.mc.console.jconsole.Messages;
import com.sun.tools.jconsole.JConsolePlugin;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import java.util.logging.Level;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;

public class JConsolePluginLoader {
    private static final String EXTENSION_POINT = "com.jrockit.mc.console.jconsole";
    private static final String EXTENSION_ATTRIBUTE_CLASS = "class";
    private static ServiceLoader<JConsolePlugin> pluginService = null;

    public static synchronized List<JConsolePlugin> getPlugins(File file) throws IOException {
        JConsolePluginLoader.initPluginService(file);
        ArrayList<JConsolePlugin> plugins = new ArrayList<JConsolePlugin>();
        if (pluginService != null) {
            for (JConsolePlugin p : pluginService) {
                plugins.add(p);
            }
        }
        return plugins;
    }

    public static List<JConsolePlugin> getExtensionPlugins() {
        ArrayList<JConsolePlugin> plugins = new ArrayList<JConsolePlugin>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = registry.getConfigurationElementsFor(EXTENSION_POINT);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement config = iConfigurationElementArray[n2];
            try {
                JConsolePlugin plugin = (JConsolePlugin)config.createExecutableExtension(EXTENSION_ATTRIBUTE_CLASS);
                plugins.add(plugin);
            }
            catch (CoreException e) {
                Activator.getLogger().log(Level.SEVERE, "Could not load JConsole plugin " + config.getName(), e);
            }
            ++n2;
        }
        return plugins;
    }

    private static void initPluginService(File file) throws IOException {
        if (file.list().length > 0) {
            URLClassLoader pluginCL = new URLClassLoader(JConsolePluginLoader.getURLs(file));
            ServiceLoader<JConsolePlugin> plugins = ServiceLoader.load(JConsolePlugin.class, pluginCL);
            pluginService = plugins;
        }
    }

    private static URL[] getURLs(File rootPath) throws IOException {
        if (!rootPath.isDirectory() || !rootPath.exists()) {
            throw new IOException(NLS.bind((String)Messages.getString("JConsolePluginLoader.MESSAGE_NOT_VALID_PLUGIN_PATH"), (Object)rootPath.toString()));
        }
        File[] files = rootPath.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                if (pathname.isDirectory()) {
                    return true;
                }
                return pathname.getName().endsWith(".jar");
            }
        });
        URL[] urls = new URL[files.length];
        int i = 0;
        while (i < files.length) {
            urls[i] = new URL("file", "", files[i].getAbsolutePath());
            ++i;
        }
        return urls;
    }
}

