/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.jconsole;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "com.jrockit.mc.console.jconsole";
    private static Logger LOGGER = Logger.getLogger("com.jrockit.mc.console.jconsole");
    private static Activator plugin;

    static {
        if (!Activator.isJConsoleClassesAvailable()) {
            Activator.attemptToAddJConsoleClassesToAppPath();
        }
    }

    private static void attemptToAddJConsoleClassesToAppPath() {
        URL toolsJar = Activator.getLibJar("tools.jar");
        URL jconsoleJar = Activator.getLibJar("jconsole.jar");
        ClassLoader parent = ClassLoader.getSystemClassLoader();
        if (toolsJar == null || jconsoleJar == null) {
            Activator.getLogger().log(Level.WARNING, "Could not locate tools.jar or jconsole.jar in the lib dir of java.home. To run the JConsole plug-in properly you need to make sure that Mission Control/Eclipse is running on a JDK and that the JDK level is 1.6 or above.");
        } else if (parent instanceof URLClassLoader) {
            try {
                Method addURL = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
                addURL.setAccessible(true);
                addURL.invoke((Object)parent, toolsJar);
                addURL.invoke((Object)parent, jconsoleJar);
            }
            catch (Exception e) {
                Activator.getLogger().log(Level.WARNING, "Could not append tools.jar or jconsole.jar to app classloader.", e);
            }
        }
        try {
            Class.forName("com.sun.tools.jconsole.JConsolePlugin", false, parent);
            Class.forName("com.sun.tools.jconsole.JConsoleContext", false, parent);
        }
        catch (Throwable t) {
            Activator.getLogger().log(Level.WARNING, "Could not locate necessary JConsole classes. You will not be able to run the Mission Controle JConsole plug-in. Make sure you're running Eclipse on an JDK 1.6 or higher.");
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public static Logger getLogger() {
        return LOGGER;
    }

    private static IPreferenceStore getPrefs() {
        return Activator.getDefault().getPreferenceStore();
    }

    public static File getJConsolePluginDir() {
        return new File(Activator.getPrefs().getString("jconsole.plugin.dir"));
    }

    public static long getUpdateInterval() {
        return Activator.getPrefs().getLong("jconsole.update.interval");
    }

    private static URL getLibJar(String name) {
        try {
            String javaHome = System.getProperty("java.home");
            File toolsJarFile = new File(javaHome, "../lib/" + name).getCanonicalFile();
            if (toolsJarFile.exists()) {
                return toolsJarFile.toURI().toURL();
            }
        }
        catch (IOException ioe) {
            Activator.getLogger().log(Level.FINER, "Problem locating tools.jar.", ioe);
        }
        return null;
    }

    public static boolean isJConsoleClassesAvailable() {
        try {
            ClassLoader parent = ClassLoader.getSystemClassLoader();
            Class.forName("com.sun.tools.jconsole.JConsolePlugin", false, parent);
            Class.forName("com.sun.tools.jconsole.JConsoleContext", false, parent);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return true;
    }
}

