/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.language.ui.syntaxcoloring;

import com.jrockit.mc.dtrace.language.dEL.ColorAnnotation;
import com.jrockit.mc.dtrace.language.dEL.DescriptionAnnotation;
import com.jrockit.mc.dtrace.language.dEL.LabelAnnotation;
import com.jrockit.mc.dtrace.language.dEL.TypeAnnotation;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.nodemodel.BidiTreeIterator;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.impl.CompositeNodeWithSemanticElement;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.syntaxcoloring.IHighlightedPositionAcceptor;
import org.eclipse.xtext.ui.editor.syntaxcoloring.ISemanticHighlightingCalculator;

public class AnnotationHighlightingCalculator
implements ISemanticHighlightingCalculator {
    private final List<Class<? extends EObject>> annotationClasses = Arrays.asList(DescriptionAnnotation.class, TypeAnnotation.class, ColorAnnotation.class, LabelAnnotation.class);

    public void provideHighlightingFor(XtextResource resource, IHighlightedPositionAcceptor acceptor) {
        if (resource == null) {
            return;
        }
        IParseResult result = resource.getParseResult();
        if (result == null) {
            return;
        }
        ICompositeNode root = result.getRootNode();
        if (root == null) {
            return;
        }
        BidiTreeIterator it = root.getAsTreeIterable().iterator();
        while (it.hasNext()) {
            INode node = (INode)it.next();
            if (!this.isAnnotationNode(node)) continue;
            this.setStyles(acceptor, (Iterator<INode>)it, "annotationStyle", "annotationStyle");
        }
    }

    private boolean isAnnotationNode(INode node) {
        return node instanceof CompositeNodeWithSemanticElement && this.annotationClasses.contains(node.getSemanticElement().getClass());
    }

    private void setStyles(IHighlightedPositionAcceptor acceptor, Iterator<INode> it, String ... styles) {
        String[] stringArray = styles;
        int n = styles.length;
        int n2 = 0;
        while (n2 < n) {
            INode node;
            String style = stringArray[n2];
            if (it.hasNext() && (node = it.next()) != null && style != null) {
                acceptor.addPosition(node.getOffset(), node.getLength(), new String[]{style});
            }
            ++n2;
        }
    }
}

