/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.dtrace.language.ui.outline;

import com.jrockit.mc.dtrace.language.dEL.CodeFragment;
import com.jrockit.mc.dtrace.language.dEL.Color;
import com.jrockit.mc.dtrace.language.dEL.ColorAnnotation;
import com.jrockit.mc.dtrace.language.dEL.DescriptionAnnotation;
import com.jrockit.mc.dtrace.language.dEL.EventDeclaration;
import com.jrockit.mc.dtrace.language.dEL.FieldDeclaration;
import com.jrockit.mc.dtrace.language.dEL.LabelAnnotation;
import com.jrockit.mc.dtrace.language.dEL.Mixin;
import com.jrockit.mc.dtrace.language.dEL.MixinDeclaration;
import com.jrockit.mc.dtrace.language.dEL.ParameterAssignment;
import com.jrockit.mc.dtrace.language.dEL.ParameterDeclaration;
import com.jrockit.mc.dtrace.language.dEL.PathAnnotation;
import com.jrockit.mc.dtrace.language.dEL.ProbeDeclaration;
import com.jrockit.mc.dtrace.language.dEL.ProbeSetAssignment;
import com.jrockit.mc.dtrace.language.dEL.ProbeSetDeclaration;
import com.jrockit.mc.dtrace.language.dEL.Program;
import com.jrockit.mc.dtrace.language.dEL.TemplateDeclaration;
import com.jrockit.mc.dtrace.language.dEL.TypeAnnotation;
import com.jrockit.mc.dtrace.language.ui.outline.Images;
import com.jrockit.mc.ui.misc.SWTColorToolkit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.xtext.ui.editor.outline.IOutlineNode;
import org.eclipse.xtext.ui.editor.outline.impl.DefaultOutlineTreeProvider;
import org.eclipse.xtext.ui.editor.outline.impl.DocumentRootNode;
import org.eclipse.xtext.ui.editor.outline.impl.EObjectNode;

public class DELOutlineTreeProvider
extends DefaultOutlineTreeProvider {
    Map<String, Image> colore = new HashMap<String, Image>();

    protected void _createNode(DocumentRootNode parentNode, Program program) {
        EObjectNode templates = new EObjectNode((EObject)program, (IOutlineNode)parentNode, Images.ICON_TEMPLATE_FOLDER, (Object)"Templates", false);
        EObjectNode parameters = new EObjectNode((EObject)program, (IOutlineNode)parentNode, Images.ICON_PARAMETERS_DECLARATION, (Object)"Parameters", false);
        EObjectNode events = new EObjectNode((EObject)program, (IOutlineNode)parentNode, Images.ICON_EVENT, (Object)"Events", false);
        EObjectNode mixins = new EObjectNode((EObject)program, (IOutlineNode)parentNode, Images.ICON_MIXINS, (Object)"Mixins", false);
        EObjectNode probes = new EObjectNode((EObject)program, (IOutlineNode)parentNode, Images.ICON_FOLDER, (Object)"Probes", false);
        ArrayList<ProbeSetDeclaration> probeset = new ArrayList<ProbeSetDeclaration>();
        ArrayList<ProbeDeclaration> probe = new ArrayList<ProbeDeclaration>();
        for (CodeFragment e : program.getCodeFragments()) {
            if (e instanceof TemplateDeclaration) {
                this.createTemplate(templates, (TemplateDeclaration)e);
            }
            if (e instanceof ParameterDeclaration) {
                this.createParameter(parameters, (ParameterDeclaration)e);
            }
            if (e instanceof EventDeclaration) {
                this.createEvent((EventDeclaration)e, events);
            }
            if (e instanceof MixinDeclaration && ((MixinDeclaration)e).getMixin() != null) {
                this.createMixin(((MixinDeclaration)e).getMixin(), mixins);
            }
            if (e instanceof ProbeSetDeclaration) {
                probeset.add((ProbeSetDeclaration)e);
            }
            if (!(e instanceof ProbeDeclaration)) continue;
            probe.add((ProbeDeclaration)e);
        }
        for (ProbeSetDeclaration ps : probeset) {
            this.createNamedNode(parameters, ps.getLabel(), (EObject)ps, ps.getName(), Images.ICON_CHECKBOX);
        }
        for (ProbeDeclaration p : probe) {
            this.createNamedNode(probes, p.getLabel(), (EObject)p, p.getName(), Images.ICON_PROBE);
        }
    }

    private void createMixin(Mixin e, EObjectNode mixins) {
        EObjectNode con = this.createNamedNode(mixins, null, (EObject)e, e.getName(), Images.ICON_MIXIN);
        this.addAllFields((EObject)e, con);
    }

    private void createEvent(EventDeclaration e, EObjectNode parent) {
        PathAnnotation pa;
        DescriptionAnnotation da;
        Color c;
        Image i = Images.ICON_EVENT;
        ColorAnnotation ca = e.getColor();
        if (ca != null && (c = ca.getColor()) instanceof com.jrockit.mc.dtrace.language.dEL.RGB) {
            com.jrockit.mc.dtrace.language.dEL.RGB r = (com.jrockit.mc.dtrace.language.dEL.RGB)c;
            int red = r.getRed();
            int green = r.getGreen();
            int blue = r.getBlue();
            String key = String.valueOf(red) + "," + green + "," + blue;
            i = this.colore.get(key);
            if (i == null) {
                i = SWTColorToolkit.getColorThumbnail((RGB)new RGB(red, green, blue));
            }
        }
        EObjectNode con = this.createNamedNode(parent, e.getLabel(), (EObject)e, e.getName(), i);
        LabelAnnotation la = e.getLabel();
        if (la != null) {
            this.createLabelAnnotation(con, la);
        }
        if ((da = e.getDescription()) != null) {
            this.createDescriptionAnnotation(con, da);
        }
        if ((pa = e.getPath()) != null) {
            this.createPathAnnotation(con, pa);
        }
        this.addAllFields((EObject)e, con);
    }

    private void addAllFields(EObject e, EObjectNode con) {
        HashSet<String> foundIdentifiers = new HashSet<String>();
        HashSet<EObject> added = new HashSet<EObject>();
        LinkedList<EObject> type = new LinkedList<EObject>();
        type.add(e);
        Image icon = Images.ICON_FIELD;
        while (!type.isEmpty()) {
            EObject object = (EObject)type.poll();
            if (added.contains(object)) continue;
            if (object instanceof EventDeclaration) {
                EventDeclaration ed = (EventDeclaration)object;
                this.addFields(con, (EList<FieldDeclaration>)ed.getFieldDeclarations(), foundIdentifiers, icon);
                this.addMixin(type, (EList<Mixin>)ed.getMixins());
            }
            if (object instanceof Mixin) {
                Mixin mi = (Mixin)object;
                this.addFields(con, (EList<FieldDeclaration>)mi.getFieldDeclarations(), foundIdentifiers, icon);
                this.addMixin(type, (EList<Mixin>)mi.getMixins());
            }
            added.add(object);
            icon = Images.ICON_EXTENDED_FIELD;
        }
    }

    private void addMixin(Queue<EObject> type, EList<Mixin> mixins) {
        for (Mixin mixin : mixins) {
            type.add((EObject)mixin);
        }
    }

    void addFields(EObjectNode con, EList<FieldDeclaration> fields, Set<String> foundIdentifiers, Image icon) {
        for (FieldDeclaration d : fields) {
            if (foundIdentifiers.contains(d.getName())) continue;
            foundIdentifiers.add(d.getName());
            this.createField(d, con, icon);
        }
    }

    private void createField(FieldDeclaration d, EObjectNode parent, Image icon) {
        TypeAnnotation ta;
        DescriptionAnnotation da;
        LabelAnnotation la = d.getLabel();
        EObjectNode con = this.createNamedNode(parent, la, (EObject)d, d.getName(), icon);
        if (la != null) {
            this.createLabelAnnotation(con, la);
        }
        if ((da = d.getDescription()) != null) {
            this.createDescriptionAnnotation(con, da);
        }
        if ((ta = d.getType()) != null) {
            this.createTypeAnnotation(con, ta);
        }
    }

    private void createParameter(EObjectNode parameters, ParameterDeclaration e) {
        TypeAnnotation ta;
        DescriptionAnnotation da;
        LabelAnnotation la = e.getLabel();
        EObjectNode con = this.createNamedNode(parameters, la, (EObject)e, e.getName(), Images.ICON_PARAMETER_DECLARATION);
        if (la != null) {
            this.createLabelAnnotation(con, la);
        }
        if ((da = e.getDescription()) != null) {
            this.createDescriptionAnnotation(con, da);
        }
        if ((ta = e.getType()) != null) {
            this.createTypeAnnotation(con, ta);
        }
    }

    private void createTemplate(EObjectNode templates, TemplateDeclaration e) {
        DescriptionAnnotation da;
        LabelAnnotation la = e.getLabel();
        EObjectNode con = this.createNamedNode(templates, la, (EObject)e, e.getName(), Images.ICON_TEMPLATE);
        if (la != null) {
            this.createLabelAnnotation(con, la);
        }
        if ((da = e.getDescription()) != null) {
            this.createDescriptionAnnotation(con, da);
        }
        for (ParameterAssignment p : e.getParameterAssignments()) {
            if (p.getParameter() == null) continue;
            this.createParameter(con, p.getParameter());
        }
        for (ProbeSetAssignment psa : e.getProbeSetAssignments()) {
            ProbeSetDeclaration psd;
            if (psa.getProbeset() == null || (psd = psa.getProbeset()).getName() == null) continue;
            this.createNamedNode(con, psd.getLabel(), (EObject)psd, psd.getName(), Images.ICON_CHECKBOX);
        }
    }

    private EObjectNode createLabelAnnotation(EObjectNode con, LabelAnnotation la) {
        EObjectNode c = this.createNode(la, con);
        c.setImage(Images.ICON_ANNOTATION);
        c.setText((Object)("name = " + la.getValue()));
        return c;
    }

    private EObjectNode createDescriptionAnnotation(EObjectNode con, DescriptionAnnotation la) {
        EObjectNode c = this.createNode(la, con);
        c.setImage(Images.ICON_ANNOTATION);
        c.setText((Object)("description = " + la.getValue()));
        return c;
    }

    private EObjectNode createTypeAnnotation(EObjectNode con, TypeAnnotation la) {
        EObjectNode c = this.createNode(la, con);
        c.setImage(Images.ICON_ANNOTATION);
        c.setText((Object)("type = " + la.getValue()));
        return c;
    }

    private EObjectNode createPathAnnotation(EObjectNode con, PathAnnotation la) {
        EObjectNode c = this.createNode(la, con);
        c.setImage(Images.ICON_ANNOTATION);
        c.setText((Object)("path = " + la.getValue()));
        return c;
    }

    private EObjectNode createNamedNode(EObjectNode parameters, LabelAnnotation l, EObject e, String def, Image image) {
        EObjectNode c = this.createNode(e, parameters);
        c.setImage(image);
        if (l != null) {
            StyledString s = new StyledString();
            s.append(String.valueOf(l.getValue()) + ' ');
            s.append(def, StyledString.QUALIFIER_STYLER);
            c.setText((Object)s);
        } else {
            StyledString s = new StyledString();
            s.append(def, StyledString.COUNTER_STYLER);
        }
        return c;
    }

    public EObjectNode createNode(EObject e, EObjectNode parentNode) {
        EObjectNode node = this.createEObjectNode((IOutlineNode)parentNode, e);
        node.setText((Object)("name = " + node.getText()));
        node.setImage(Images.ICON_ANNOTATION);
        return node;
    }

    public EObjectNode createNode(LabelAnnotation la, EObjectNode parentNode) {
        EObjectNode node = this.createEObjectNode((IOutlineNode)parentNode, (EObject)la);
        node.setText((Object)("name = " + node.getText()));
        node.setImage(Images.ICON_ANNOTATION);
        return node;
    }

    public EObjectNode createNode(PathAnnotation pa, EObjectNode parentNode) {
        EObjectNode node = this.createEObjectNode((IOutlineNode)parentNode, (EObject)pa);
        node.setText((Object)("path = " + node.getText()));
        node.setImage(Images.ICON_ANNOTATION);
        return node;
    }

    public EObjectNode createNode(DescriptionAnnotation da, EObjectNode parentNode) {
        EObjectNode node = this.createEObjectNode((IOutlineNode)parentNode, (EObject)da);
        node.setText((Object)("description = " + node.getText()));
        node.setImage(Images.ICON_ANNOTATION);
        return node;
    }

    public EObjectNode createNode(TypeAnnotation ta, EObjectNode parentNode) {
        EObjectNode node = this.createEObjectNode((IOutlineNode)parentNode, (EObject)ta);
        node.setText((Object)("type = " + node.getText()));
        node.setImage(Images.ICON_ANNOTATION);
        return node;
    }
}

