/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.twitter;

import com.jrockit.mc.common.persistence.ISettingFetcher;
import com.jrockit.mc.common.persistence.PersistenceToolkit;
import com.jrockit.mc.common.persistence.Setting;
import com.jrockit.mc.common.persistence.Type;
import com.jrockit.mc.console.twitter.Tweeter;
import java.util.List;
import java.util.Observable;
import twitter4j.auth.AccessToken;

public final class TwitterSettings
extends Observable {
    private static final String TWEETERS = "tweeters";
    private final Setting m_setting = new Setting("twittersSetting");

    static {
        PersistenceToolkit.registerFetcher(TwitterSettings.class, (ISettingFetcher)new ISettingFetcher<TwitterSettings>(){

            public Setting getSetting(TwitterSettings twitterSettings) {
                return twitterSettings.m_setting;
            }
        });
    }

    List<Tweeter> getTweeters() {
        return (List)this.m_setting.getChildObject(TWEETERS, new Type(List.class, new Type[]{new Type(Tweeter.class)}));
    }

    void addTweeter(AccessToken accessToken) {
        List<Tweeter> tweeters = this.getTweeters();
        Tweeter tweeter = new Tweeter();
        tweeter.setUsername(accessToken.getScreenName());
        tweeter.setToken(accessToken.getToken());
        tweeter.setTokenSecret(accessToken.getTokenSecret());
        if (!this.getTweeters().contains(tweeter)) {
            tweeters.add(tweeter);
            this.setChanged();
        }
    }

    void removeTweeter(Tweeter tweeter) {
        List<Tweeter> tweeters = this.getTweeters();
        tweeters.remove(tweeter);
        this.setChanged();
    }
}

