/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.twitter;

import com.jrockit.mc.console.twitter.ITweeterChangeListener;
import com.jrockit.mc.console.twitter.Tweeter;
import com.jrockit.mc.console.twitter.TwitterPlugin;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import twitter4j.Twitter;
import twitter4j.auth.RequestToken;

public class TwitterPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Text m_pin;
    private Button finishButton;
    private RequestToken m_requestToken;
    private Control m_authorizationButton;
    private Twitter m_twitter;
    private TableViewer m_viewer;
    private Control m_removeButton;

    public TwitterPreferencePage() {
    }

    public TwitterPreferencePage(String title) {
        super(title);
    }

    public TwitterPreferencePage(String title, ImageDescriptor image) {
        super(title, image);
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        this.resetTwitter();
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(3, false));
        this.writeText(container, "Before an application, like Java Mission Control, is allowed to tweet, the application needs to be authorized.");
        this.writeText(container, "Click Authorize to start authorization. A web browser will appear where you can grant Mission Control permission. The Twitter user you log in as in the web browser is the one that will be usable from within Mission Control.");
        GridData gd2 = new GridData(4, 4, false, false);
        this.m_authorizationButton = this.createAuthorizeButton(container);
        this.m_authorizationButton.setLayoutData((Object)gd2);
        this.writeText(container, "Then enter the PIN that is shown in the web browser and click Add.");
        GridData gd5 = new GridData(4, 0x1000000, false, false);
        Label l2 = new Label(container, 0);
        l2.setText("PIN:");
        l2.setLayoutData((Object)gd5);
        GridData gd9 = new GridData(4, 4, true, false);
        this.m_pin = this.createPinField(container);
        this.m_pin.setLayoutData((Object)gd9);
        this.m_pin.setEnabled(false);
        GridData gd4 = new GridData(4, 4, false, false);
        this.finishButton = this.createAddButton(container);
        this.finishButton.setLayoutData((Object)gd4);
        this.finishButton.setEnabled(false);
        this.writeText(container, "Authorized Users:");
        GridData gd10 = new GridData(4, 4, true, true);
        gd10.horizontalSpan = 2;
        gd10.verticalSpan = 2;
        this.m_viewer = this.createTableViewer(container);
        this.m_viewer.getControl().setLayoutData((Object)gd10);
        GridData gd11 = new GridData(4, 1, false, false);
        gd11.verticalSpan = 2;
        this.m_removeButton = this.createRemoveButton(container);
        this.m_removeButton.setLayoutData((Object)gd11);
        this.m_removeButton.setEnabled(false);
        this.hookViewerRefresh();
        return container;
    }

    private void resetTwitter() {
        this.m_twitter = TwitterPlugin.getDefault().getTwitter();
        this.m_requestToken = null;
    }

    void updateEnablement() {
        this.m_removeButton.setEnabled(TwitterPlugin.getDefault().getTweeters().size() > 0);
    }

    private void hookViewerRefresh() {
        this.m_viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TwitterPreferencePage.this.updateEnablement();
            }
        });
    }

    private Button createRemoveButton(Composite container) {
        Button b = new Button(container, 0);
        b.setText("Remove");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection ss = (IStructuredSelection)TwitterPreferencePage.this.m_viewer.getSelection();
                if (!ss.isEmpty()) {
                    TwitterPlugin.getDefault().getTwitterSettings().removeTweeter((Tweeter)ss.getFirstElement());
                    TwitterPreferencePage.this.m_viewer.refresh();
                }
            }
        });
        return b;
    }

    private TableViewer createTableViewer(Composite parent) {
        Table table = new Table(parent, 67588);
        table.setLinesVisible(true);
        final TableViewer viewer = new TableViewer(table);
        new TableColumn(table, 0);
        TableLayout tl = new TableLayout();
        tl.addColumnData((ColumnLayoutData)new ColumnWeightData(1));
        table.setLayout((Layout)tl);
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        viewer.setInput(TwitterPlugin.getDefault().getTweeters());
        TwitterPlugin.getDefault().addTweeterChangeListener(new ITweeterChangeListener(){

            @Override
            public void onChange() {
                if (!viewer.getTable().isDisposed()) {
                    viewer.refresh();
                } else {
                    TwitterPlugin.getDefault().removeTweeterChangeListener(this);
                }
            }
        });
        return viewer;
    }

    public boolean performOk() {
        return true;
    }

    private void writeText(Composite parent, String text) {
        GridData gd0 = new GridData(4, 4, false, false);
        gd0.horizontalSpan = 3;
        gd0.widthHint = 200;
        Label desc = new Label(parent, 64);
        desc.setText(text);
        desc.setLayoutData((Object)gd0);
    }

    private Text createPinField(Composite container) {
        final Text t = new Text(container, 2048);
        t.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TwitterPreferencePage.this.finishButton.setEnabled(t.getText().length() > 0);
            }
        });
        return t;
    }

    private Button createAddButton(Composite container) {
        Button b = new Button(container, 0);
        b.setText("Add");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TwitterPlugin.getDefault().addTweeter(TwitterPreferencePage.this.m_twitter, TwitterPreferencePage.this.m_requestToken, TwitterPreferencePage.this.m_pin.getText().trim());
                TwitterPreferencePage.this.m_pin.setText("");
            }
        });
        return b;
    }

    private Button createAuthorizeButton(Composite container) {
        Button b = new Button(container, 0);
        b.setText("Authorize");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TwitterPreferencePage.this.resetTwitter();
                TwitterPreferencePage.this.m_requestToken = TwitterPlugin.getDefault().authorize(TwitterPreferencePage.this.m_twitter);
                boolean enabled = TwitterPreferencePage.this.m_requestToken != null;
                TwitterPreferencePage.this.finishButton.setEnabled(enabled);
                TwitterPreferencePage.this.m_pin.setEnabled(enabled);
            }
        });
        return b;
    }
}

