/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.twitter;

import com.jrockit.mc.common.persistence.PersistenceToolkit;
import com.jrockit.mc.common.string.StringToolkit;
import com.jrockit.mc.console.twitter.ITweeterChangeListener;
import com.jrockit.mc.console.twitter.Tweeter;
import com.jrockit.mc.console.twitter.TwitterSettings;
import com.jrockit.mc.core.MCVersion;
import com.jrockit.mc.rjmx.triggers.TriggerEvent;
import com.jrockit.mc.ui.misc.DialogToolkit;
import com.jrockit.mc.ui.misc.ExceptionDialog;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.net.proxy.IProxyChangeEvent;
import org.eclipse.core.net.proxy.IProxyChangeListener;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.program.Program;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import twitter4j.Twitter;
import twitter4j.TwitterException;
import twitter4j.TwitterFactory;
import twitter4j.auth.AccessToken;
import twitter4j.auth.RequestToken;
import twitter4j.conf.ConfigurationBuilder;

public class TwitterPlugin
extends AbstractUIPlugin {
    private static final String VARIABLE_VALUE = "{value}";
    private static final String VARIABLE_STATE = "{state}";
    public static final String PLUGIN_ID = "com.jrockit.mc.twitter";
    static final Logger LOGGER = Logger.getLogger("com.jrockit.mc.twitter");
    private static TwitterPlugin plugin;
    private TwitterSettings m_twitterSetting;
    private TwitterFactory m_twitterFactory;
    private final String CONSUMER_KEY = "zLp4UUsRoIDvfuC4Xa89WA";
    private final String CONSUMER_SECRET = "ScvGPLoE0bOWqVBs48KVOhL0vwczfgwqwDQI1LQ";
    private final IProxyChangeListener proxyListener;
    private IProxyService proxyService;
    private final ListenerList m_listenerList = new ListenerList();

    public TwitterPlugin() {
        this.proxyListener = new IProxyChangeListener(){

            public void proxyInfoChanged(IProxyChangeEvent event) {
                TwitterPlugin.this.recreateFactory();
            }
        };
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.proxyService = this.setupProxyService(context);
        plugin = this;
        File twitterFile = this.getTwitterFile();
        if (twitterFile.exists() && !this.isEmpty(twitterFile)) {
            try {
                this.m_twitterSetting = (TwitterSettings)PersistenceToolkit.createObjectFromFile(TwitterSettings.class, (File)twitterFile);
            }
            catch (RuntimeException e) {
                LOGGER.log(Level.INFO, "Could not parse the twitter settings. Will create new settings.", e);
                this.m_twitterSetting = new TwitterSettings();
            }
        } else {
            this.m_twitterSetting = new TwitterSettings();
        }
        this.m_twitterSetting.addObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                Object[] objectArray = TwitterPlugin.this.m_listenerList.getListeners();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    ITweeterChangeListener tcl = (ITweeterChangeListener)object;
                    tcl.onChange();
                    ++n2;
                }
            }
        });
        this.m_twitterFactory = this.createTwitterFactory();
    }

    private boolean isEmpty(File twitterFile) {
        String contents;
        block3: {
            try {
                contents = StringToolkit.readString((File)twitterFile);
                if (contents != null) break block3;
                return true;
            }
            catch (IOException e) {
                LOGGER.log(Level.INFO, "Could not read the twitter settings file.", e);
                return true;
            }
        }
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>".equals(contents.trim());
    }

    private IProxyService setupProxyService(BundleContext context) {
        IProxyService service = (IProxyService)context.getService(context.getServiceReference(IProxyService.class));
        service.addProxyChangeListener(this.proxyListener);
        return service;
    }

    private TwitterFactory createTwitterFactory() {
        ConfigurationBuilder cb = new ConfigurationBuilder();
        try {
            IProxyData[] data = this.proxyService.select(new URI("http://api.twitter.com"));
            String host = null;
            int port = -1;
            IProxyData[] iProxyDataArray = data;
            int n = data.length;
            int n2 = 0;
            while (n2 < n) {
                IProxyData proxyData = iProxyDataArray[n2];
                if (proxyData.getHost() != null) {
                    host = proxyData.getHost();
                    port = proxyData.getPort();
                    break;
                }
                ++n2;
            }
            if (host != null) {
                cb.setHttpProxyHost(host);
            }
            if (port != -1) {
                cb.setHttpProxyPort(port);
            } else {
                cb.setHttpProxyPort(80);
            }
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return new TwitterFactory(cb.build());
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
        this.proxyService.removeProxyChangeListener(this.proxyListener);
        this.proxyService = null;
        PersistenceToolkit.exportObjectToFile((Object)this.m_twitterSetting, (File)this.getTwitterFile());
    }

    private File getTwitterFile() throws IOException {
        File dir = new File(this.getStateLocation().toFile(), MCVersion.getPluginVersion((Plugin)this));
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IOException("Could not create directory " + dir);
        }
        return new File(dir, "twitter.xml");
    }

    public static TwitterPlugin getDefault() {
        return plugin;
    }

    public RequestToken authorize(Twitter twitter) {
        try {
            twitter.setOAuthConsumer("zLp4UUsRoIDvfuC4Xa89WA", "ScvGPLoE0bOWqVBs48KVOhL0vwczfgwqwDQI1LQ");
        }
        catch (IllegalStateException e) {
            LOGGER.log(Level.INFO, "Could not set OAuth Consumer. Most likely this has already been done before.", e);
        }
        try {
            RequestToken requestToken = twitter.getOAuthRequestToken();
            Program.launch((String)requestToken.getAuthorizationURL());
            return requestToken;
        }
        catch (TwitterException e) {
            LOGGER.log(Level.SEVERE, "Could not request token!", e);
            ExceptionDialog.openExceptionDialog(null, (String)"Problem when Authorizing", (String)("Problem when trying to connect to Twitter for authorization. Check your network and proxy settings. If you make any changes, a restart may be required. \n\nException message: " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    public Tweeter getAuthorizedTweeter(String userName) {
        for (Tweeter tweeter : this.m_twitterSetting.getTweeters()) {
            if (!userName.equals(tweeter.getUserName())) continue;
            return tweeter;
        }
        return null;
    }

    public void updateStatus(String userName, String message) throws TwitterException {
        Tweeter tweeter = this.getAuthorizedTweeter(userName);
        if (tweeter != null) {
            AccessToken at = this.createAccessToken(tweeter);
            Twitter twitter = this.m_twitterFactory.getInstance();
            twitter.setOAuthConsumer("zLp4UUsRoIDvfuC4Xa89WA", "ScvGPLoE0bOWqVBs48KVOhL0vwczfgwqwDQI1LQ");
            twitter.setOAuthAccessToken(at);
            twitter.updateStatus(message);
            System.out.println("Updated status: " + message);
            return;
        }
        throw new TwitterException(String.format("Attempted to update status for an account not defined in the preferences. Please set up the account (%s) in preferences first.", userName));
    }

    private AccessToken createAccessToken(Tweeter tweeter) {
        return new AccessToken(tweeter.getToken(), tweeter.getTokenSecret());
    }

    public void addTweeter(Twitter twitter, RequestToken rt, String pin) {
        try {
            AccessToken accessToken = pin.length() > 0 ? twitter.getOAuthAccessToken(rt, pin) : twitter.getOAuthAccessToken();
            String screenName = accessToken.getScreenName();
            if (screenName != null && screenName.length() > 0) {
                this.m_twitterSetting.addTweeter(accessToken);
                this.m_twitterSetting.notifyObservers();
                MessageDialog.openInformation(null, (String)"Twitter Authorization", (String)("Access credentials created successfully for user " + screenName + "."));
            } else {
                ExceptionDialog.openError(null, (String)"Invalid User", (String)"The authorized user is invalid.");
            }
        }
        catch (TwitterException ex) {
            ExceptionDialog.openExceptionDialog(null, (String)"Error storing access token", (String)ex.getMessage(), (Throwable)ex);
        }
    }

    public void addTweeterChangeListener(ITweeterChangeListener tcl) {
        this.m_listenerList.add((Object)tcl);
    }

    public void removeTweeterChangeListener(ITweeterChangeListener tcl) {
        this.m_listenerList.remove((Object)tcl);
    }

    public void removeTweeter(Tweeter tweeter) {
        this.m_twitterSetting.removeTweeter(tweeter);
    }

    public List<Tweeter> getTweeters() {
        return this.m_twitterSetting.getTweeters();
    }

    public Twitter getTwitter() {
        return this.m_twitterFactory.getInstance();
    }

    public TwitterSettings getTwitterSettings() {
        return this.m_twitterSetting;
    }

    public Logger getLogger() {
        return LOGGER;
    }

    public void sendDirectMessage(String from, String to, String message) throws Exception {
        Tweeter tweeter = this.getAuthorizedTweeter(from);
        if (tweeter == null) {
            throw new Exception(String.format("Attempted to send direct message from account not defined in the preferences. Please set up the account (%s) in preferences first.", from));
        }
        AccessToken at = this.createAccessToken(tweeter);
        Twitter twitter = this.m_twitterFactory.getInstance();
        twitter.setOAuthConsumer("zLp4UUsRoIDvfuC4Xa89WA", "ScvGPLoE0bOWqVBs48KVOhL0vwczfgwqwDQI1LQ");
        twitter.setOAuthAccessToken(at);
        twitter.sendDirectMessage(to, message);
    }

    private void recreateFactory() {
        this.m_twitterFactory = this.createTwitterFactory();
    }

    public static String createMessage(String msg, TriggerEvent event) {
        String result = msg.replace(VARIABLE_STATE, TwitterPlugin.getStateString(event));
        if ((result = result.replace(VARIABLE_VALUE, String.valueOf(event.getTriggerValue()))).length() > 140) {
            result = String.valueOf(result.substring(0, 137)) + "...";
        }
        return result;
    }

    private static String getStateString(TriggerEvent event) {
        return event.wasTriggered() ? "triggered" : "recovered";
    }

    public boolean verifyAuthorizedUser(String userName) {
        if (this.getAuthorizedTweeter(userName) != null) {
            return true;
        }
        DialogToolkit.showError(null, (String)"Unauthorized Twitter User", (String)("User " + userName + " has not been authorized in Preferences"));
        return false;
    }
}

