/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.dtrace.recorder.internal.remote;

import com.jrockit.mc.dtrace.recorder.internal.remote.StreamCleanUpThread;
import com.jrockit.mc.dtrace.recorder.internal.remote.StreamHandle;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

final class StreamManager {
    private static volatile AtomicInteger s_streamIdentifier = new AtomicInteger();
    private final List<StreamHandle> m_streams = new ArrayList<StreamHandle>();
    private final int m_timeOut;
    private StreamCleanUpThread m_cleanUpThread;

    StreamManager(int timeOut) {
        this.m_timeOut = timeOut;
    }

    public synchronized StreamHandle registerStream(InputStream is) {
        int streamIdentifier = s_streamIdentifier.incrementAndGet();
        StreamHandle stream = new StreamHandle(is, streamIdentifier, 131072);
        this.m_streams.add(stream);
        if (this.m_streams.size() == 1) {
            this.startCleanUpThread();
        }
        return stream;
    }

    public synchronized void cleanUp() {
        long now = System.currentTimeMillis();
        for (StreamHandle s : this.m_streams) {
            if (s.getLastAccess() + (long)this.m_timeOut <= now) continue;
            s.close();
            this.m_streams.remove(s);
        }
        if (this.m_streams.size() == 0) {
            this.stopCleanUpThread();
        }
    }

    public synchronized void unregisterStream(StreamHandle s) {
        this.m_streams.remove(s);
    }

    public synchronized StreamHandle findStream(int identifier) {
        for (StreamHandle stream : this.m_streams) {
            if (stream.getIdentifier() != identifier) continue;
            return stream;
        }
        return null;
    }

    private void stopCleanUpThread() {
        this.m_cleanUpThread.kill();
        this.m_cleanUpThread = null;
    }

    private void startCleanUpThread() {
        this.m_cleanUpThread = new StreamCleanUpThread(this, 120000L);
        this.m_cleanUpThread.start();
    }
}

