/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.dtrace.recorder.internal.remote;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;

final class StreamHandle
implements Closeable {
    private final int m_streamIdentifier;
    private final InputStream m_inputStream;
    private final byte[] m_buffer;
    private volatile long m_lastAccess;

    StreamHandle(InputStream inputStream, int streamIdentfier, int bufferSize) {
        this.m_streamIdentifier = streamIdentfier;
        this.m_buffer = new byte[bufferSize];
        this.m_inputStream = inputStream;
    }

    public byte[] readData() throws IOException {
        int read = this.m_inputStream.read(this.m_buffer);
        if (read > 0) {
            this.updateAccess();
            if (read < this.m_buffer.length) {
                byte[] buffer = new byte[read];
                System.arraycopy(this.m_buffer, 0, buffer, 0, read);
                return buffer;
            }
            return this.m_buffer;
        }
        return null;
    }

    public void updateAccess() {
        this.m_lastAccess = System.currentTimeMillis();
    }

    public long getLastAccess() {
        return this.m_lastAccess;
    }

    @Override
    public synchronized void close() {
        try {
            this.m_inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public int getIdentifier() {
        return this.m_streamIdentifier;
    }
}

