/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.dtrace.recorder.internal.remote;

import com.jrockit.mc.dtrace.recorder.internal.remote.StreamManager;

final class StreamCleanUpThread
extends Thread {
    private final StreamManager m_streamManager;
    private final long m_pollInterval;
    private volatile boolean m_keepAlive;

    StreamCleanUpThread(StreamManager streamManager, long pollInterval) {
        this.m_streamManager = streamManager;
        this.m_pollInterval = pollInterval;
    }

    @Override
    public void run() {
        while (this.m_keepAlive) {
            this.m_streamManager.cleanUp();
            this.takeNap();
        }
    }

    private void takeNap() {
        try {
            Thread.sleep(this.m_pollInterval);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void kill() {
        this.m_keepAlive = false;
    }
}

