/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.dtrace.recorder.internal.remote;

import com.jrockit.mc.common.persistence.PersistenceToolkit;
import com.jrockit.mc.dtrace.recorder.DTraceRecorder;
import com.jrockit.mc.dtrace.recorder.ProbeDescriptor;
import com.jrockit.mc.dtrace.recorder.ProcessDescriptor;
import com.jrockit.mc.dtrace.recorder.RecordingDescriptor;
import com.jrockit.mc.dtrace.recorder.RecordingOptions;
import com.jrockit.mc.dtrace.recorder.internal.remote.MBeanToolkit;
import com.jrockit.mc.dtrace.recorder.internal.remote.ProbeConverter;
import com.jrockit.mc.dtrace.recorder.internal.remote.ProcessConverter;
import com.jrockit.mc.dtrace.recorder.internal.remote.RecordingConverter;
import com.jrockit.mc.dtrace.recorder.internal.remote.RecordingInputStream;
import com.jrockit.mc.dtrace.recorder.internal.remote.RecordingOptionConverter;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.OpenDataException;

public final class RemoteRecorder
implements DTraceRecorder {
    private final MBeanServerConnection m_server;
    private final ObjectName m_objectName;

    public RemoteRecorder(MBeanServerConnection server, ObjectName objectName) {
        this.m_server = server;
        this.m_objectName = objectName;
    }

    @Override
    public boolean stopRecording(RecordingDescriptor recording) {
        Object result = MBeanToolkit.invokeOperation(this.m_server, this.m_objectName, "stopRecording", recording.getIdentifier());
        return Boolean.TRUE.equals(result);
    }

    @Override
    public RecordingDescriptor startRecording(String script, String metadata, RecordingOptions options) {
        try {
            CompositeData cd = RecordingOptionConverter.INSTANCE.toCompositeData(options);
            Integer result = (Integer)MBeanToolkit.invokeOperation(this.m_server, this.m_objectName, "startRecording", script, metadata, cd);
            RecordingOptions copy = (RecordingOptions)PersistenceToolkit.createCopy((Object)options);
            RecordingDescriptor rd = new RecordingDescriptor(copy, result);
            return rd;
        }
        catch (OpenDataException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<ProbeDescriptor> getProbes() {
        return MBeanToolkit.getList(this.m_server, this.m_objectName, "Probes", ProbeConverter.getInstance());
    }

    @Override
    public List<RecordingDescriptor> getAvailableRecordings() {
        return MBeanToolkit.getList(this.m_server, this.m_objectName, "AvailableRecordings", RecordingConverter.getInstance());
    }

    @Override
    public List<ProcessDescriptor> getProcesses(String executableFilter) {
        return MBeanToolkit.getList(this.m_server, this.m_objectName, "getProcesses", ProcessConverter.getInstance(), executableFilter);
    }

    @Override
    public InputStream openStream(RecordingDescriptor recording) throws IOException {
        return new RecordingInputStream(recording, this.m_server, this.m_objectName);
    }

    @Override
    public long getTime() {
        Object result = MBeanToolkit.invokeOperation(this.m_server, this.m_objectName, "Time", new Object[0]);
        if (result instanceof Long) {
            return (Long)result;
        }
        throw new RuntimeException("Missing server time");
    }

    @Override
    public Boolean getSetupState() throws Exception {
        Object result = MBeanToolkit.invokeOperation(this.m_server, this.m_objectName, "SetupState", new Object[0]);
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        throw new Exception("Could not verify server setup");
    }

    @Override
    public Integer getThisPID() {
        Object result = MBeanToolkit.invokeOperation(this.m_server, this.m_objectName, "ThisPID", new Object[0]);
        if (result instanceof Integer) {
            return (Integer)result;
        }
        throw new RuntimeException("Missing this pid");
    }
}

