/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.dtrace.recorder.internal.remote;

import com.jrockit.mc.common.persistence.PersistenceToolkit;
import com.jrockit.mc.common.persistence.Setting;
import com.jrockit.mc.dtrace.recorder.RecordingOptions;
import com.jrockit.mc.dtrace.recorder.internal.remote.AbstractConverter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;

public class RecordingOptionConverter
extends AbstractConverter<RecordingOptions> {
    static AbstractConverter<RecordingOptions> INSTANCE = new RecordingOptionConverter();

    @Override
    public CompositeData toCompositeData(RecordingOptions options) throws OpenDataException {
        Setting setting = PersistenceToolkit.getSetting((Object)options);
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<String> descriptions = new ArrayList<String>();
        ArrayList<SimpleType<String>> types = new ArrayList<SimpleType<String>>();
        HashMap props = new HashMap(setting.getProperties());
        for (Map.Entry entry : setting.getProperties().entrySet()) {
            names.add((String)entry.getKey());
            descriptions.add("Description not available");
            types.add(SimpleType.STRING);
        }
        String[] namesArray = names.toArray(new String[names.size()]);
        OpenType[] typeArray = types.toArray(new OpenType[types.size()]);
        String[] desacriptionArray = descriptions.toArray(new String[descriptions.size()]);
        try {
            CompositeType type = new CompositeType("options", "Recording Options", namesArray, desacriptionArray, typeArray);
            return new CompositeDataSupport(type, props);
        }
        catch (OpenDataException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public RecordingOptions toObject(CompositeData cd) {
        RecordingOptions options = new RecordingOptions();
        Setting s = PersistenceToolkit.getSetting((Object)options);
        Map props = s.getProperties();
        for (String key : cd.getCompositeType().keySet()) {
            props.put(String.valueOf(key), (String)cd.get(key));
        }
        return options;
    }
}

