/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.dtrace.recorder.internal.remote;

import com.jrockit.mc.dtrace.recorder.RecordingDescriptor;
import com.jrockit.mc.dtrace.recorder.internal.remote.MBeanToolkit;
import java.io.IOException;
import java.io.InputStream;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

public final class RecordingInputStream
extends InputStream {
    private static final Integer UNKNOWN_STREAM = -1;
    private final RecordingDescriptor m_recording;
    private final MBeanServerConnection m_server;
    private final ObjectName m_objectName;
    private byte[] m_buffer = new byte[0];
    private int m_count = 0;
    private int m_position = 0;
    private boolean m_closed = false;
    private boolean m_endOfStream = false;
    private Integer m_streamIdentifier = UNKNOWN_STREAM;

    public RecordingInputStream(RecordingDescriptor recording, MBeanServerConnection server, ObjectName objectName) {
        this.m_recording = recording;
        this.m_server = server;
        this.m_objectName = objectName;
    }

    @Override
    public synchronized int read() throws IOException {
        if (this.m_position >= this.m_buffer.length) {
            if (this.m_closed || this.m_endOfStream) {
                return -1;
            }
            this.fill();
            if (this.m_endOfStream) {
                return -1;
            }
        }
        return this.m_buffer[this.m_position++] & 0xFF;
    }

    private void fill() throws IOException {
        if (UNKNOWN_STREAM.equals(this.m_streamIdentifier)) {
            this.m_streamIdentifier = this.openStream(this.m_recording);
        }
        this.m_buffer = this.readStream(this.m_streamIdentifier);
        if (this.m_buffer != null) {
            this.m_count += this.m_buffer.length;
            this.m_position = 0;
        } else {
            this.m_position = 0;
            this.m_count = 0;
            this.m_buffer = new byte[0];
            this.m_endOfStream = true;
        }
    }

    private void ensureOpen() throws IOException {
        if (this.m_closed) {
            throw new IOException("Stream closed");
        }
    }

    @Override
    public synchronized int available() throws IOException {
        this.ensureOpen();
        return this.m_count - this.m_position;
    }

    @Override
    public void close() throws IOException {
        if (this.m_closed) {
            return;
        }
        this.m_closed = true;
        if (!UNKNOWN_STREAM.equals(this.m_streamIdentifier)) {
            this.closeStream(this.m_streamIdentifier);
        }
    }

    private void closeStream(int streamIdentifier) throws IOException {
        this.invokeOperation("closeStream", new Object[]{streamIdentifier});
    }

    private Object invokeOperation(String operationName, Object[] params) throws IOException {
        return MBeanToolkit.invokeOperation(this.m_server, this.m_objectName, operationName, params);
    }

    private byte[] readStream(int streamIdentifier) throws IOException {
        return (byte[])this.invokeOperation("readBinaryData", new Object[]{streamIdentifier});
    }

    private Integer openStream(RecordingDescriptor recording) throws IOException {
        Integer streamId = (Integer)this.invokeOperation("openStream", new Object[]{recording.getIdentifier()});
        if (streamId == null) {
            return UNKNOWN_STREAM;
        }
        return streamId;
    }
}

