/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.dtrace.recorder.internal.remote;

import com.jrockit.mc.dtrace.recorder.RecordingDescriptor;
import com.jrockit.mc.dtrace.recorder.RecordingOptions;
import com.jrockit.mc.dtrace.recorder.RecordingState;
import com.jrockit.mc.dtrace.recorder.internal.remote.AbstractConverter;
import com.jrockit.mc.dtrace.recorder.internal.remote.RecordingOptionConverter;
import java.io.File;
import java.util.HashMap;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;

class RecordingConverter
extends AbstractConverter<RecordingDescriptor> {
    static AbstractConverter<RecordingDescriptor> INSTANCE = new RecordingConverter();
    private static String[] ITEM_NAME = new String[]{"identifier", "state", "error", "options", "fileName"};
    private static String[] ITEM_DESCRIPTIONS = new String[]{"A unique identifier for the recording.", "The current state of the recording.", "Errors that occured during the recording", "Options for the recording.", "File name for the recording."};

    RecordingConverter() {
    }

    @Override
    public CompositeData toCompositeData(RecordingDescriptor recording) throws OpenDataException {
        CompositeData optionCompositeData = RecordingOptionConverter.INSTANCE.toCompositeData(recording.getRecordingOptions());
        OpenType<?>[] types = this.createTypes(optionCompositeData.getCompositeType());
        CompositeType ct = new CompositeType("recording", "DTrace recording", ITEM_NAME, ITEM_DESCRIPTIONS, types);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("identifier", recording.getIdentifier());
        map.put("state", recording.getRecordingState().getIdentifier());
        map.put("error", recording.getErrorMessage());
        map.put("options", optionCompositeData);
        map.put("fileName", recording.getFile().toString());
        return new CompositeDataSupport(ct, map);
    }

    private OpenType<?>[] createTypes(OpenType<?> optionType) throws OpenDataException {
        return new OpenType[]{SimpleType.INTEGER, SimpleType.STRING, SimpleType.STRING, optionType, SimpleType.STRING};
    }

    @Override
    public RecordingDescriptor toObject(CompositeData cd) {
        String recordingState = (String)cd.get("state");
        CompositeData optionsCompositeData = (CompositeData)cd.get("options");
        RecordingOptions options = RecordingOptionConverter.INSTANCE.toObject(optionsCompositeData);
        Integer id = (Integer)cd.get("identifier");
        RecordingDescriptor r = new RecordingDescriptor(options, id);
        r.setState(RecordingState.lookup(recordingState));
        r.setErrorMessages((String)cd.get("error"));
        r.setFile(new File((String)cd.get("fileName")));
        return r;
    }

    public static AbstractConverter<RecordingDescriptor> getInstance() {
        return INSTANCE;
    }
}

