/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.dtrace.recorder.internal.remote;

import com.jrockit.mc.dtrace.recorder.ProcessDescriptor;
import com.jrockit.mc.dtrace.recorder.internal.remote.AbstractConverter;
import java.util.HashMap;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;

class ProcessConverter
extends AbstractConverter<ProcessDescriptor> {
    private static AbstractConverter<ProcessDescriptor> INSTANCE = new ProcessConverter();
    private static String[] ITEM_NAME = new String[]{"pid", "path", "exec", "args"};
    private static String[] ITEM_DESCRIPTIONS = new String[]{"A unique identifier for the process", "The path to the specified process", "The executable name of the process", "The arguments the process was started with"};
    private static OpenType<?>[] ITEM_TYPES = new OpenType[]{SimpleType.INTEGER, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING};

    ProcessConverter() {
    }

    @Override
    public CompositeData toCompositeData(ProcessDescriptor pd) throws OpenDataException {
        CompositeType ct = new CompositeType("process", "Process", ITEM_NAME, ITEM_DESCRIPTIONS, ITEM_TYPES);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pid", pd.getIdentifier());
        map.put("path", pd.getPath());
        map.put("exec", pd.getExecutable());
        map.put("args", pd.getArguments());
        CompositeDataSupport cd = new CompositeDataSupport(ct, map);
        return cd;
    }

    @Override
    public ProcessDescriptor toObject(CompositeData cd) {
        ProcessDescriptor pd = new ProcessDescriptor();
        pd.setIdentifier((Integer)cd.get("pid"));
        pd.setPath((String)cd.get("path"));
        pd.setExecutable((String)cd.get("exec"));
        pd.setArguments((String)cd.get("args"));
        return pd;
    }

    public static AbstractConverter<ProcessDescriptor> getInstance() {
        return INSTANCE;
    }
}

