/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.dtrace.recorder.internal.remote;

import com.jrockit.mc.dtrace.recorder.ProbeDescriptor;
import com.jrockit.mc.dtrace.recorder.internal.remote.AbstractConverter;
import java.util.HashMap;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;

class ProbeConverter
extends AbstractConverter<ProbeDescriptor> {
    private static AbstractConverter<ProbeDescriptor> INSTANCE = new ProbeConverter();
    String[] itemNames = new String[]{"identifier", "provider", "module", "functionName"};
    String[] itemDescriptions = new String[]{"A unique identigier for the probe", "The probe provider", "The module the probe belongs to", "The function name of the probe"};
    OpenType<?>[] types = new OpenType[]{SimpleType.INTEGER, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING};

    ProbeConverter() {
    }

    @Override
    public CompositeData toCompositeData(ProbeDescriptor probe) throws OpenDataException {
        CompositeType t = new CompositeType("probe", "DTrace probe", this.itemNames, this.itemDescriptions, this.types);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("identifier", probe.getIdentifier());
        map.put("provider", probe.getProvider());
        map.put("module", probe.getModule());
        map.put("module", probe.getFunctionName());
        return new CompositeDataSupport(t, map);
    }

    @Override
    public ProbeDescriptor toObject(CompositeData cd) {
        Integer identifier = (Integer)cd.get("identifier");
        String module = (String)cd.get("module");
        String functionName = (String)cd.get("functionName");
        String provider = (String)cd.get("provider");
        ProbeDescriptor pd = new ProbeDescriptor();
        pd.setModule(module);
        pd.setFunctionName(functionName);
        pd.setProvider(provider);
        pd.setIdentifier(identifier);
        return pd;
    }

    public static AbstractConverter<ProbeDescriptor> getInstance() {
        return INSTANCE;
    }
}

