/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.dtrace.recorder.internal.remote;

import com.jrockit.mc.dtrace.recorder.internal.remote.AbstractConverter;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.List;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeData;

final class MBeanToolkit {
    MBeanToolkit() {
    }

    public static <T> List<T> getList(MBeanServerConnection server, ObjectName name, String operationName, AbstractConverter<T> converter) {
        return MBeanToolkit.getList(server, name, operationName, converter, new Object[0]);
    }

    public static <T> List<T> getList(MBeanServerConnection server, ObjectName name, String operationName, AbstractConverter<T> converter, Object ... params) {
        Object o = MBeanToolkit.invokeOperation(server, name, operationName, params);
        if (o instanceof List) {
            List list = (List)o;
            return converter.toObjectList(list);
        }
        return new ArrayList();
    }

    public static Object invokeOperation(MBeanServerConnection server, ObjectName name, String operationName, Object ... params) {
        try {
            if (params.length == 0) {
                return server.getAttribute(name, operationName);
            }
            return server.invoke(name, operationName, params, MBeanToolkit.extractSignature(params));
        }
        catch (InstanceNotFoundException e) {
            MBeanToolkit.rethrowBadInvoke(e, operationName);
        }
        catch (ReflectionException e) {
            MBeanToolkit.rethrowBadInvoke(e, operationName);
        }
        catch (MBeanException e) {
            MBeanToolkit.rethrowBadInvoke(e, operationName);
        }
        catch (IOException e) {
            MBeanToolkit.rethrowBadInvoke(e, operationName);
        }
        catch (AttributeNotFoundException e) {
            MBeanToolkit.rethrowBadInvoke(e, operationName);
        }
        return null;
    }

    private static void rethrowBadInvoke(Exception e, String operationName) {
        throw new RuntimeException("Could not invoke operation " + operationName + " on DTraceMBean", e);
    }

    private static String[] extractSignature(Object[] paramaters) {
        String[] signatures = new String[paramaters.length];
        int i = 0;
        while (i < signatures.length) {
            signatures[i] = MBeanToolkit.extractSignature(paramaters[i]);
            ++i;
        }
        return signatures;
    }

    private static String extractSignature(Object param) {
        if (param.getClass() == Boolean.class) {
            return Boolean.TYPE.getName();
        }
        if (Number.class.isAssignableFrom(param.getClass())) {
            return MBeanToolkit.extractNumber(param);
        }
        if (CompositeData.class.isAssignableFrom(param.getClass())) {
            return CompositeData.class.getName();
        }
        if (List.class.isAssignableFrom(param.getClass())) {
            return List.class.getName();
        }
        return param.getClass().getName();
    }

    private static String extractNumber(Object param) {
        try {
            return ((Class)param.getClass().getField("TYPE").get(param)).getName();
        }
        catch (IllegalArgumentException e) {
            throw new UndeclaredThrowableException(e);
        }
        catch (SecurityException e) {
            throw new UndeclaredThrowableException(e);
        }
        catch (IllegalAccessException e) {
            throw new UndeclaredThrowableException(e);
        }
        catch (NoSuchFieldException e) {
            throw new UndeclaredThrowableException(e);
        }
    }
}

