/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.dtrace.recorder.internal.remote;

import com.jrockit.mc.dtrace.recorder.DTraceMBean;
import com.jrockit.mc.dtrace.recorder.DTraceRecorder;
import com.jrockit.mc.dtrace.recorder.RecordingDescriptor;
import com.jrockit.mc.dtrace.recorder.RecordingOptions;
import com.jrockit.mc.dtrace.recorder.RecordingState;
import com.jrockit.mc.dtrace.recorder.internal.remote.ProbeConverter;
import com.jrockit.mc.dtrace.recorder.internal.remote.ProcessConverter;
import com.jrockit.mc.dtrace.recorder.internal.remote.RecordingConverter;
import com.jrockit.mc.dtrace.recorder.internal.remote.RecordingOptionConverter;
import com.jrockit.mc.dtrace.recorder.internal.remote.StreamHandle;
import com.jrockit.mc.dtrace.recorder.internal.remote.StreamManager;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import javax.management.openmbean.CompositeData;

public final class DTrace
extends StandardMBean
implements DTraceMBean {
    private final DTraceRecorder m_server;
    private final StreamManager m_streamManager;

    public DTrace(DTraceRecorder server) throws NotCompliantMBeanException {
        super(DTraceMBean.class);
        this.m_server = server;
        this.m_streamManager = new StreamManager(1000);
    }

    public StreamHandle createStream(RecordingDescriptor recording) throws IOException {
        if (recording.getRecordingState() == RecordingState.FINISHED) {
            InputStream is = this.m_server.openStream(recording);
            return this.m_streamManager.registerStream(is);
        }
        throw new RuntimeException("The recording needs to complete before data can be transferred");
    }

    @Override
    public boolean stopRecording(int id) {
        RecordingDescriptor recording = this.findRecording(id);
        if (recording != null) {
            return this.m_server.stopRecording(recording);
        }
        return false;
    }

    @Override
    public int startRecording(String script, String metadata, CompositeData cd) throws IOException {
        RecordingOptions os = RecordingOptionConverter.INSTANCE.toObject(cd);
        RecordingDescriptor recording = this.m_server.startRecording(script, metadata, os);
        return recording.getIdentifier();
    }

    @Override
    public int openStream(int recordingIdentifier) throws IOException {
        for (RecordingDescriptor recording : this.m_server.getAvailableRecordings()) {
            if (recording.getIdentifier() != recordingIdentifier) continue;
            StreamHandle s = this.createStream(recording);
            return s.getIdentifier();
        }
        return -1;
    }

    @Override
    public byte[] readBinaryData(int streamIdentifier) throws IOException {
        StreamHandle s = this.m_streamManager.findStream(streamIdentifier);
        if (s != null) {
            return s.readData();
        }
        throw new IOException("Can't find a stream with identifier " + streamIdentifier);
    }

    @Override
    public void closeStream(int streamIdentifier) throws IllegalArgumentException {
        StreamHandle s = this.m_streamManager.findStream(streamIdentifier);
        if (s != null) {
            s.close();
            this.m_streamManager.unregisterStream(s);
        }
    }

    @Override
    public long getCurrentTime() {
        return System.currentTimeMillis();
    }

    private RecordingDescriptor findRecording(int recordingIdentifier) {
        for (RecordingDescriptor recording : this.m_server.getAvailableRecordings()) {
            if (recording.getIdentifier() != recordingIdentifier) continue;
            return recording;
        }
        return null;
    }

    @Override
    public List<CompositeData> getAvailableRecordings() {
        return RecordingConverter.getInstance().toCompositeDataList(this.m_server.getAvailableRecordings());
    }

    @Override
    public List<CompositeData> getProcesses(String executableFilter) {
        return ProcessConverter.getInstance().toCompositeDataList(this.m_server.getProcesses(executableFilter));
    }

    @Override
    public List<CompositeData> getProbes() {
        return ProbeConverter.getInstance().toCompositeDataList(this.m_server.getProbes());
    }

    @Override
    public Boolean getSetupState() throws Exception {
        return this.m_server.getSetupState();
    }

    @Override
    public Integer getThisPID() {
        return this.m_server.getThisPID();
    }
}

