/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.dtrace.recorder.internal.mockup;

import com.jrockit.mc.dtrace.recorder.DTraceRecorder;
import com.jrockit.mc.dtrace.recorder.ProbeDescriptor;
import com.jrockit.mc.dtrace.recorder.ProcessDescriptor;
import com.jrockit.mc.dtrace.recorder.RecordingDescriptor;
import com.jrockit.mc.dtrace.recorder.RecordingOptions;
import com.jrockit.mc.dtrace.recorder.RecordingState;
import com.jrockit.mc.dtrace.recorder.internal.mockup.Mockup;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class MockupRecorder
implements DTraceRecorder {
    private final Map<Integer, RecordingDescriptor> m_recordingLookup = new HashMap<Integer, RecordingDescriptor>();
    private final List<ProcessDescriptor> m_processes = new ArrayList<ProcessDescriptor>();
    private final String m_newRecordingResourceName;

    public MockupRecorder(Mockup mockup, String newRecordingResourceName) {
        this.m_newRecordingResourceName = newRecordingResourceName;
        this.m_processes.addAll(mockup.getProcesses());
        for (RecordingDescriptor rec : mockup.getRecordings()) {
            this.m_recordingLookup.put(rec.getIdentifier(), rec);
        }
    }

    @Override
    public synchronized boolean stopRecording(RecordingDescriptor recording) {
        return this.m_recordingLookup.remove(recording.getIdentifier()) != null;
    }

    @Override
    public synchronized RecordingDescriptor startRecording(String script, String metdata, RecordingOptions options) throws IOException {
        RecordingDescriptor recording = new RecordingDescriptor();
        recording.setState(RecordingState.RUNNING);
        this.m_recordingLookup.put(recording.getIdentifier(), recording);
        return recording;
    }

    @Override
    public synchronized List<ProbeDescriptor> getProbes() {
        return new ArrayList<ProbeDescriptor>();
    }

    @Override
    public synchronized List<RecordingDescriptor> getAvailableRecordings() {
        return new ArrayList<RecordingDescriptor>(this.m_recordingLookup.values());
    }

    @Override
    public synchronized List<ProcessDescriptor> getProcesses(String executableFilter) {
        return this.m_processes;
    }

    @Override
    public synchronized InputStream openStream(RecordingDescriptor recording) throws IOException {
        return MockupRecorder.class.getResourceAsStream(this.m_newRecordingResourceName);
    }

    @Override
    public synchronized long getTime() {
        return System.currentTimeMillis();
    }

    @Override
    public Boolean getSetupState() throws Exception {
        return Boolean.TRUE;
    }

    @Override
    public Integer getThisPID() {
        return 0;
    }
}

