/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.dtrace.recorder.internal.local;

import com.jrockit.mc.common.io.IOToolkit;
import com.jrockit.mc.dtrace.recorder.RecordingDescriptor;
import com.jrockit.mc.dtrace.recorder.RecordingState;
import com.jrockit.mc.dtrace.recorder.internal.local.DTraceProcess;
import com.jrockit.mc.dtrace.recorder.internal.local.LocalRecorder;
import com.jrockit.mc.dtrace.recorder.internal.local.RecordingPackage;
import com.jrockit.mc.dtrace.recorder.internal.local.RunningThreads;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;

final class ScriptRunner
implements Runnable {
    private final RecordingDescriptor m_recording;
    private final String m_script;
    private final LocalRecorder m_server;
    private final String m_metadata;
    private volatile DTraceProcess m_process;

    ScriptRunner(LocalRecorder server, RecordingDescriptor recording, String script, String metadata) {
        this.m_metadata = metadata;
        this.m_server = server;
        this.m_recording = recording;
        this.m_script = script;
    }

    @Override
    public void run() {
        block5: {
            File scriptFile = null;
            File metadataFile = null;
            File outputFile = null;
            File threadnamesFile = null;
            try {
                try {
                    scriptFile = this.createScriptFile();
                    metadataFile = this.createMetadataFile();
                    outputFile = this.createOutputFile();
                    threadnamesFile = this.createThreadnamesFile();
                    this.executeSafe(scriptFile, metadataFile, outputFile, threadnamesFile);
                }
                catch (IOException e) {
                    System.out.println("Could not create script file " + scriptFile);
                    this.deleteFileIfExist(outputFile);
                    this.deleteFileIfExist(metadataFile);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                this.deleteFileIfExist(outputFile);
                this.deleteFileIfExist(metadataFile);
                throw throwable;
            }
            this.deleteFileIfExist(outputFile);
            this.deleteFileIfExist(metadataFile);
        }
    }

    private File createOutputFile() throws IOException {
        return this.createTempFile("script", ".out");
    }

    private File createThreadnamesFile() throws IOException {
        return this.createTempFile("threadnames", ".out");
    }

    private void deleteFileIfExist(File file) {
        if (file != null && file.exists() && !file.delete()) {
            Logger.getLogger("com.jrockit.mc.dtrace.recorder").severe(String.format("Could not delete file %s", file.toString()));
        }
    }

    private File createMetadataFile() throws IOException {
        File metadataFile = this.createTempFile("metadata", ".xml");
        IOToolkit.saveToFile((File)metadataFile, (String)this.m_metadata);
        return metadataFile;
    }

    private File createTempFile(String name, String suffix) throws IOException {
        File file = File.createTempFile(name, suffix);
        this.deleteFileIfExist(file);
        System.out.println("Created file: " + file);
        return file;
    }

    void executeSafe(File scriptFile, File metadataFile, File outputFile, File threadnamesFile) {
        try {
            this.execute(scriptFile, metadataFile, outputFile, threadnamesFile);
        }
        catch (IOException e) {
            System.out.println("Error executing script.");
            e.printStackTrace();
        }
    }

    private void execute(File scriptFile, File metadataFile, File outputFile, File threadnamesFile) throws IOException {
        try {
            System.out.println("Writing to " + outputFile.getAbsolutePath() + " ...");
            this.m_recording.setState(RecordingState.RUNNING);
            this.m_server.addScriptRun(this);
            String pid = "" + this.m_recording.getRecordingOptions().getProcessIdentifier();
            RunningThreads.printRunningThreadsToFile(threadnamesFile, pid);
            this.m_process = DTraceProcess.create(this.m_recording.getRecordingOptions(), outputFile, scriptFile);
            this.m_process.waitFor();
            System.out.println(this.m_process.getErrorMessage());
            this.m_recording.setErrorMessages(this.m_process.getErrorMessage());
            RecordingPackage rp = new RecordingPackage(outputFile, metadataFile, threadnamesFile);
            this.m_recording.setFile(rp.createPackage());
        }
        finally {
            this.m_server.finishRecording(this.m_recording);
        }
    }

    private File createScriptFile() throws IOException {
        File scriptFile = this.createTempFile("script", ".d");
        IOToolkit.saveToFile((File)scriptFile, (String)this.m_script);
        return scriptFile;
    }

    public void kill() {
        if (this.m_process != null) {
            this.m_process.kill();
        }
    }

    public RecordingDescriptor getRecording() {
        return this.m_recording;
    }
}

