/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.dtrace.recorder.internal.local;

import com.jrockit.mc.common.io.IOToolkit;
import com.sun.tools.attach.VirtualMachine;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import sun.tools.attach.HotSpotVirtualMachine;

public final class RunningThreads {
    private static final String THREAD_RUNNING_EVENT_BEGIN_ID = "ThreadRunning...";

    public static void printRunningThreadsToFile(File file, String pid) {
        block5: {
            System.out.println("Printing running threads for pid " + pid + " to " + file.getPath());
            FileWriter fw = null;
            try {
                try {
                    fw = new FileWriter(file);
                    RunningThreads.printThreadsToWriter(pid, fw);
                }
                catch (Exception e) {
                    System.out.println("Could not write java thread information. ");
                    IOToolkit.closeSilently((Closeable)fw);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                IOToolkit.closeSilently(fw);
                throw throwable;
            }
            IOToolkit.closeSilently((Closeable)fw);
        }
    }

    private static void printThreadsToWriter(String pid, Writer fw) throws IOException {
        BufferedWriter bw = new BufferedWriter(fw);
        for (ThreadDescriptor td : RunningThreads.listRunningThreads(pid)) {
            long timestamp = 1L;
            int thread = td.getIdentifier();
            bw.write(String.valueOf(timestamp) + " " + THREAD_RUNNING_EVENT_BEGIN_ID + " \"" + td.getName() + "\" " + thread + "\n");
        }
        bw.close();
    }

    public static List<ThreadDescriptor> listRunningThreads(String pid) {
        if (Integer.parseInt(pid) > 0) {
            ArrayList<ThreadDescriptor> td;
            block23: {
                td = new ArrayList<ThreadDescriptor>();
                VirtualMachine vm = null;
                InputStream in = null;
                try {
                    String s;
                    vm = VirtualMachine.attach(pid);
                    in = ((HotSpotVirtualMachine)vm).remoteDataDump(new Object[0]);
                    BufferedReader bis = new BufferedReader(new InputStreamReader(in));
                    while ((s = bis.readLine()) != null) {
                        int threadEnd;
                        int end;
                        if (s.length() <= 2 || s.charAt(0) != '\"' || (end = s.indexOf("\"", 1)) == -1) continue;
                        String name = s.substring(1, end);
                        int threadStart = s.indexOf("nid=0x");
                        if (threadStart != -1 && (threadEnd = s.indexOf(32, threadStart)) != -1) {
                            String tid = s.substring(threadStart + 6, threadEnd);
                            try {
                                Long l = Long.parseLong(tid, 16);
                                ThreadDescriptor t = new ThreadDescriptor(l.intValue(), name);
                                td.add(t);
                            }
                            catch (NumberFormatException nfe) {
                                System.out.println("Could not parse thread id: " + nfe);
                            }
                        }
                        System.out.println(name);
                    }
                    bis.close();
                }
                catch (Exception x) {
                    System.err.println("Problems when getting threads for pid " + pid + ": " + x.getMessage());
                    IOToolkit.closeSilently((Closeable)in);
                    if (vm != null) {
                        try {
                            vm.detach();
                        }
                        catch (IOException iOException) {}
                    }
                    break block23;
                }
                catch (NoClassDefFoundError err) {
                    try {
                        System.err.println("WARNING: Recording will not contain thread name info. Could not find attach classes when getting threads for pid " + pid + " (tools.jar lacking from bootclasspath?):");
                        err.printStackTrace();
                    }
                    catch (Throwable throwable) {
                        IOToolkit.closeSilently(in);
                        if (vm != null) {
                            try {
                                vm.detach();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        throw throwable;
                    }
                    IOToolkit.closeSilently((Closeable)in);
                    if (vm != null) {
                        try {
                            vm.detach();
                        }
                        catch (IOException iOException) {}
                    }
                    break block23;
                }
                IOToolkit.closeSilently((Closeable)in);
                if (vm != null) {
                    try {
                        vm.detach();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            return td;
        }
        return new ArrayList<ThreadDescriptor>();
    }

    public static final class ThreadDescriptor {
        private final String m_name;
        private final int m_threadIdentifier;

        ThreadDescriptor(int threadIdentifier, String name) {
            this.m_name = name;
            this.m_threadIdentifier = threadIdentifier;
        }

        int getIdentifier() {
            return this.m_threadIdentifier;
        }

        String getName() {
            return this.m_name;
        }
    }
}

