/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.dtrace.recorder.internal.local;

import com.jrockit.mc.common.io.IOToolkit;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;

final class RecordingPackage {
    private static final String METADATA_FILENAME = "metadata.xml";
    private static final String LOG_FILE_NAME = "log.clf";
    private final File m_logFile;
    private final File m_metadata;
    private final File m_preprocess;

    RecordingPackage(File logFile, File metadata, File preprocess) {
        this.m_logFile = logFile;
        this.m_metadata = metadata;
        this.m_preprocess = preprocess;
    }

    public File createPackage() throws IOException {
        File recordingFile = this.createRecordingFile();
        recordingFile.deleteOnExit();
        FileOutputStream fileout = new FileOutputStream(recordingFile);
        JarOutputStream jarout = null;
        FileInputStream fisLog = null;
        FileInputStream fisPre = null;
        FileInputStream fisMeta = null;
        try {
            jarout = new JarOutputStream(fileout);
            fisLog = new FileInputStream(this.m_logFile);
            jarout.putNextEntry(new ZipEntry(LOG_FILE_NAME));
            IOToolkit.copy((InputStream)fisLog, (OutputStream)jarout);
            fisPre = new FileInputStream(this.m_preprocess);
            IOToolkit.copy((InputStream)fisPre, (OutputStream)jarout);
            fisMeta = new FileInputStream(this.m_metadata);
            jarout.putNextEntry(new ZipEntry(METADATA_FILENAME));
            IOToolkit.copy((InputStream)fisMeta, (OutputStream)jarout);
            jarout.close();
        }
        catch (Throwable throwable) {
            IOToolkit.closeSilently(jarout);
            IOToolkit.closeSilently((Closeable)fileout);
            IOToolkit.closeSilently(fisLog);
            IOToolkit.closeSilently(fisPre);
            IOToolkit.closeSilently(fisMeta);
            throw throwable;
        }
        IOToolkit.closeSilently((Closeable)jarout);
        IOToolkit.closeSilently((Closeable)fileout);
        IOToolkit.closeSilently((Closeable)fisLog);
        IOToolkit.closeSilently((Closeable)fisPre);
        IOToolkit.closeSilently((Closeable)fisMeta);
        System.out.println("Recording created at " + recordingFile);
        return recordingFile;
    }

    public byte[] createChecksum(String filename) throws NoSuchAlgorithmException, IOException {
        byte[] byArray;
        FileInputStream fis = null;
        try {
            int numRead;
            fis = new FileInputStream(filename);
            byte[] buffer = new byte[1024];
            MessageDigest complete = MessageDigest.getInstance("MD5");
            do {
                if ((numRead = ((InputStream)fis).read(buffer)) <= 0) continue;
                complete.update(buffer, 0, numRead);
            } while (numRead != -1);
            byArray = complete.digest();
        }
        catch (Throwable throwable) {
            IOToolkit.closeSilently(fis);
            throw throwable;
        }
        IOToolkit.closeSilently((Closeable)fis);
        return byArray;
    }

    public String getMD5Checksum(String filename) throws NoSuchAlgorithmException, IOException {
        byte[] b = this.createChecksum(filename);
        String result = "";
        byte[] byArray = b;
        int n = b.length;
        int n2 = 0;
        while (n2 < n) {
            byte element = byArray[n2];
            result = String.valueOf(result) + Integer.toString((element & 0xFF) + 256, 16).substring(1);
            ++n2;
        }
        return result;
    }

    private File createRecordingFile() throws IOException {
        return File.createTempFile("dtraceRecording", ".jar");
    }
}

