/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.dtrace.recorder.internal.local;

import com.jrockit.mc.common.environment.OS;
import com.jrockit.mc.common.io.IOToolkit;
import com.jrockit.mc.common.parsing.Token;
import com.jrockit.mc.common.parsing.Tokenizer;
import com.jrockit.mc.common.string.StringToolkit;
import com.jrockit.mc.dtrace.recorder.ProcessDescriptor;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

final class ProcessDescriptorFactory {
    ProcessDescriptorFactory() {
    }

    /*
     * Loose catch block
     */
    public static List<ProcessDescriptor> createProcessDescriptors(String executableFilter) {
        List<ProcessDescriptor> list;
        InputStream is = null;
        try {
            Process process = Runtime.getRuntime().exec("ps -e -o pid= -o args=");
            is = process.getInputStream();
            list = ProcessDescriptorFactory.processInputStream(is, executableFilter);
        }
        catch (IOException e) {
            IOToolkit.closeSilently(is);
            return null;
            catch (Throwable throwable) {
                IOToolkit.closeSilently(is);
                throw throwable;
            }
        }
        IOToolkit.closeSilently((Closeable)is);
        return list;
    }

    public static boolean checkPs() {
        Process process;
        try {
            process = Runtime.getRuntime().exec("ps -o pid=");
            process.waitFor();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not get process information from the OS. Make sure the correct ps command is available.", e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Could not get process information from the OS. Make sure the correct ps command is available.", e);
        }
        return process.exitValue() == 0;
    }

    private static List<ProcessDescriptor> processInputStream(InputStream is, String executableFilter) throws IOException {
        ArrayList<ProcessDescriptor> list = new ArrayList<ProcessDescriptor>();
        BufferedReader r = new BufferedReader(new InputStreamReader(is));
        String line = null;
        try {
            do {
                ProcessDescriptor pd;
                if ((pd = ProcessDescriptorFactory.processLine(line = r.readLine(), executableFilter)) == null) continue;
                list.add(pd);
            } while (line != null);
        }
        finally {
            IOToolkit.closeSilently((Closeable)r);
        }
        return list;
    }

    private static ProcessDescriptor processLine(String line, String executableFilter) {
        if (line != null && line.trim().length() > 0) {
            return ProcessDescriptorFactory.createProcessDescriptor(line, executableFilter);
        }
        return null;
    }

    private static ProcessDescriptor createProcessDescriptor(String line, String executableFilter) {
        ProcessDescriptor pd = new ProcessDescriptor();
        Tokenizer tokenizer = new Tokenizer(line);
        Token pid = tokenizer.next();
        Token comm = tokenizer.next();
        if (tokenizer.getTokenCount() == 2 && comm.text.length() >= 2 && comm.text.startsWith("[") && comm.text.endsWith("]")) {
            return null;
        }
        ProcessDescriptorFactory.findPathAndExecutable(comm.text, pd);
        if (ProcessDescriptorFactory.isInFilter(pd, executableFilter)) {
            String arguments = ProcessDescriptorFactory.isSolaris() ? ProcessDescriptorFactory.getPargsArguments(pid) : ProcessDescriptorFactory.getPsArguments(line);
            pd.setArguments(arguments);
            pd.setIdentifier(Integer.parseInt(pid.text));
            return pd;
        }
        return null;
    }

    private static boolean isInFilter(ProcessDescriptor pd, String executableFilter) {
        String executable = pd.getExecutable();
        if (executableFilter != null && executable != null) {
            return executable.equalsIgnoreCase(executableFilter) || executable.matches(executableFilter);
        }
        return true;
    }

    private static boolean isSolaris() {
        return OS.getType() == OS.Type.SOLARIS;
    }

    private static String getPsArguments(String line) {
        Tokenizer tokenizer = new Tokenizer(line);
        tokenizer.next();
        tokenizer.next();
        StringBuilder args = new StringBuilder();
        if (tokenizer.getTokenCount() >= 3) {
            while (tokenizer.hasNext()) {
                args.append(tokenizer.next().text);
                args.append(' ');
            }
            args.deleteCharAt(args.length() - 1);
        }
        return args.toString();
    }

    private static String getPargsArguments(Token pid) {
        try {
            Process process = Runtime.getRuntime().exec("pargs -a " + pid);
            return ProcessDescriptorFactory.processPargsOutput(process.getInputStream());
        }
        catch (IOException e) {
            return "";
        }
    }

    private static String processPargsOutput(InputStream is) throws IOException {
        StringTokenizer pargsOutput = new StringTokenizer(StringToolkit.readString((InputStream)is), "\n\r");
        ArrayList<String> arguments = new ArrayList<String>();
        while (pargsOutput.hasMoreTokens()) {
            String arg = ProcessDescriptorFactory.getArgs(pargsOutput.nextToken());
            if (arg == null) continue;
            arguments.add(arg);
        }
        return StringToolkit.join(arguments, (String)" ");
    }

    private static String getArgs(String line) {
        if (line != null && ProcessDescriptorFactory.isArgsLine(line) && !ProcessDescriptorFactory.isExecutableLine(line)) {
            return ProcessDescriptorFactory.stripArgsPrefix(line);
        }
        return null;
    }

    private static String stripArgsPrefix(String line) {
        return line.replaceFirst("argv\\[\\d+\\]:", "").trim();
    }

    private static boolean isArgsLine(String line) {
        return line.contains("argv[");
    }

    private static boolean isExecutableLine(String line) {
        return line.contains("argv[0]");
    }

    private static void findPathAndExecutable(String processName, ProcessDescriptor out) {
        int index = processName.length();
        int test = 49;
        while (index > 0 && test != 47) {
            test = processName.charAt(--index);
        }
        if (index == 0) {
            out.setExecutable(processName);
            out.setPath(ProcessDescriptorFactory.findPath(processName));
        } else {
            out.setExecutable(processName.substring(index + 1));
            out.setPath(processName);
        }
    }

    /*
     * Loose catch block
     */
    private static String findPath(String executable) {
        String string;
        BufferedReader r;
        block13: {
            r = null;
            if (executable.startsWith("-")) {
                executable = executable.substring(1);
            }
            Process process = Runtime.getRuntime().exec("which " + executable);
            r = new BufferedReader(new InputStreamReader(process.getInputStream()));
            string = r.readLine();
            if (r == null) break block13;
            try {
                r.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return string;
        catch (IOException ioe) {
            if (r != null) {
                try {
                    r.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return null;
            catch (Throwable throwable) {
                if (r != null) {
                    try {
                        r.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }
}

