/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.dtrace.recorder.internal.local;

import com.jrockit.mc.common.io.IOToolkit;
import com.jrockit.mc.dtrace.recorder.ProbeDescriptor;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

final class ProbeScanner {
    private static final Integer ID_START = 0;
    private static final Integer ID_END = 1;
    private static final Integer PROVIDER_START = 2;
    private static final Integer PROVIDER_END = 3;
    private static final Integer MODULE_START = 4;
    private static final Integer MODULE_END = 5;
    private static final Integer FUNCTION_NAME_START = 6;
    private static final Integer FN_START_NO_MODULE = 4;
    private static final Integer MAX_NUMBER_OF_INDICES = 8;
    private final ArrayList<ProbeDescriptor> m_probes = new ArrayList();

    ProbeScanner() {
    }

    public List<ProbeDescriptor> scan() {
        block5: {
            this.m_probes.clear();
            InputStream is = null;
            try {
                try {
                    Process process = Runtime.getRuntime().exec("dtrace -l");
                    is = process.getInputStream();
                    this.processInputStream(is);
                }
                catch (IOException iOException) {
                    IOToolkit.closeSilently(is);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                IOToolkit.closeSilently(is);
                throw throwable;
            }
            IOToolkit.closeSilently((Closeable)is);
        }
        return this.m_probes;
    }

    private void processInputStream(InputStream inputStream) throws IOException {
        BufferedInputStream is = new BufferedInputStream(inputStream);
        BufferedReader r = new BufferedReader(new InputStreamReader(is));
        String line = null;
        do {
            line = r.readLine();
            this.processLine(line);
        } while (line != null);
    }

    private void processLine(String line) {
        ProbeDescriptor p;
        if (line != null && line.trim().length() > 0 && (p = ProbeScanner.createProbe(line)) != null) {
            this.m_probes.add(p);
        }
    }

    private static ProbeDescriptor createProbe(String line) {
        List<Integer> indices = ProbeScanner.FindIndices(line);
        try {
            ProbeDescriptor pd = new ProbeDescriptor();
            pd.setIdentifier(Integer.parseInt(line.substring(indices.get(ID_START), indices.get(ID_END))));
            pd.setProvider(line.substring(indices.get(PROVIDER_START), indices.get(PROVIDER_END)));
            if (indices.size() < MAX_NUMBER_OF_INDICES) {
                pd.setModule("");
                pd.setFunctionName(line.substring(indices.get(FN_START_NO_MODULE)));
            } else {
                pd.setModule(line.substring(indices.get(MODULE_START), indices.get(MODULE_END)));
                pd.setFunctionName(line.substring(indices.get(FUNCTION_NAME_START)));
            }
            return pd;
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    private static List<Integer> FindIndices(String line) {
        ArrayList<Integer> indices = new ArrayList<Integer>(MAX_NUMBER_OF_INDICES);
        int index = 0;
        boolean spaceFound = false;
        boolean charFound = false;
        int i = 0;
        while (i < line.length()) {
            if (index >= MAX_NUMBER_OF_INDICES) break;
            char test = line.charAt(i);
            if (test == ' ' && !spaceFound) {
                indices.add(index++, i);
                spaceFound = true;
                charFound = false;
            }
            if (test != ' ' && !charFound) {
                indices.add(index++, i);
                spaceFound = false;
                charFound = true;
            }
            ++i;
        }
        return indices;
    }

    public boolean checkDTrace() throws Exception {
        Process process;
        String expectedOutput = "no probes specified";
        String dtraceCmd = "dtrace -v";
        ProcessBuilder pb = new ProcessBuilder("dtrace -v".split(" "));
        pb.redirectErrorStream(true);
        try {
            process = pb.start();
        }
        catch (IOException e) {
            throw new Exception("Could not execute DTrace. Make sure the OS supports Dtrace and that the Java process has priviliges to execute Dtrace.", e);
        }
        String output = null;
        try {
            output = this.getOutput(process);
        }
        catch (IOException e) {
            throw new Exception("Exception while reading output from command dtrace -v", e);
        }
        if (output != null && output.length() <= 0) {
            throw new Exception("No output from 'dtrace -v'");
        }
        if (output.contains("no probes specified")) {
            return true;
        }
        throw new Exception("Did not get the expected output 'no probes specified' from command 'dtrace -v");
    }

    private String getOutput(Process process) throws Exception {
        InputStream is = process.getInputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
        }
        finally {
            IOToolkit.closeSilently((Closeable)br);
        }
        return sb.toString();
    }
}

