/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.dtrace.recorder.internal.local;

import com.jrockit.mc.common.mbean.LocalMBeanToolkit;
import com.jrockit.mc.common.persistence.PersistenceToolkit;
import com.jrockit.mc.dtrace.recorder.DTraceRecorder;
import com.jrockit.mc.dtrace.recorder.ProbeDescriptor;
import com.jrockit.mc.dtrace.recorder.ProcessDescriptor;
import com.jrockit.mc.dtrace.recorder.RecordingDescriptor;
import com.jrockit.mc.dtrace.recorder.RecordingOptions;
import com.jrockit.mc.dtrace.recorder.RecordingState;
import com.jrockit.mc.dtrace.recorder.internal.local.ProbeScanner;
import com.jrockit.mc.dtrace.recorder.internal.local.ProcessDescriptorFactory;
import com.jrockit.mc.dtrace.recorder.internal.local.ScriptRunner;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class LocalRecorder
implements DTraceRecorder {
    private final List<RecordingDescriptor> m_recordings = new ArrayList<RecordingDescriptor>();
    private final List<ScriptRunner> m_scriptRuns = new ArrayList<ScriptRunner>();

    List<ScriptRunner> getRunningScripts() {
        return Arrays.asList(this.m_scriptRuns.toArray(new ScriptRunner[0]));
    }

    public synchronized List<RecordingDescriptor> getRecordings() {
        return Arrays.asList(this.m_recordings.toArray(new RecordingDescriptor[0]));
    }

    @Override
    public synchronized InputStream openStream(RecordingDescriptor recording) throws IOException {
        if (recording.getRecordingState() == RecordingState.FINISHED) {
            return new BufferedInputStream(new FileInputStream(recording.getFile()));
        }
        throw new RuntimeException("The recording needs to complete before data can be transferred.");
    }

    public synchronized void destroy() {
    }

    @Override
    public synchronized boolean stopRecording(RecordingDescriptor recording) {
        for (ScriptRunner sc : this.m_scriptRuns) {
            if (!sc.getRecording().equals(recording)) continue;
            sc.kill();
            return true;
        }
        return false;
    }

    @Override
    public synchronized RecordingDescriptor startRecording(String script, String metadata, RecordingOptions options) throws IOException {
        RecordingOptions copy = (RecordingOptions)PersistenceToolkit.createCopy((Object)options);
        RecordingDescriptor recording = new RecordingDescriptor(copy);
        ScriptRunner sc = new ScriptRunner(this, recording, script, metadata);
        recording.setState(RecordingState.NOT_STARTED);
        Thread t = new Thread(sc);
        t.start();
        return recording;
    }

    public synchronized void addScriptRun(ScriptRunner scriptRunner) {
        this.m_scriptRuns.add(scriptRunner);
    }

    public synchronized void removeScriptRun(ScriptRunner scriptRunner) {
        this.m_scriptRuns.remove(scriptRunner);
    }

    public synchronized void finishRecording(RecordingDescriptor recording) {
        ScriptRunner sc = this.findScriptRunner(recording);
        this.m_scriptRuns.remove(sc);
        this.m_recordings.add(recording);
        System.out.println("setting state finished for " + recording.getIdentifier());
        recording.setState(RecordingState.FINISHED);
    }

    private ScriptRunner findScriptRunner(RecordingDescriptor recording) {
        for (ScriptRunner sc : this.m_scriptRuns) {
            if (sc.getRecording().getIdentifier() != recording.getIdentifier()) continue;
            return sc;
        }
        return null;
    }

    @Override
    public synchronized List<ProbeDescriptor> getProbes() {
        return new ProbeScanner().scan();
    }

    @Override
    public synchronized List<ProcessDescriptor> getProcesses(String executableFilter) {
        List<ProcessDescriptor> descriptors = ProcessDescriptorFactory.createProcessDescriptors(executableFilter);
        if (descriptors == null) {
            return new ArrayList<ProcessDescriptor>();
        }
        return descriptors;
    }

    @Override
    public synchronized List<RecordingDescriptor> getAvailableRecordings() {
        ArrayList<RecordingDescriptor> retList = new ArrayList<RecordingDescriptor>();
        for (ScriptRunner sc : this.m_scriptRuns) {
            retList.add(sc.getRecording());
        }
        for (RecordingDescriptor rd : this.m_recordings) {
            retList.add(rd);
        }
        return retList;
    }

    @Override
    public long getTime() {
        return System.currentTimeMillis();
    }

    @Override
    public Boolean getSetupState() throws Exception {
        if (new ProbeScanner().checkDTrace() && ProcessDescriptorFactory.checkPs()) {
            return true;
        }
        return false;
    }

    @Override
    public Integer getThisPID() {
        return LocalMBeanToolkit.getThisPID();
    }
}

