/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.dtrace.recorder.internal.local;

import com.jrockit.mc.common.io.IOToolkit;
import com.jrockit.mc.dtrace.recorder.RecordingOptions;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

final class DTraceProcess {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final long NAP_TIME = 1000L;
    private static final long TIMEOUT_FACTOR = 4L;
    private final RecordingOptions m_options;
    private final Process m_process;
    private Thread timeouter;
    protected boolean timedOut = false;

    DTraceProcess(RecordingOptions options, Process process) {
        this.m_options = options;
        this.m_process = process;
    }

    private static boolean isVerbose() {
        return true;
    }

    public static DTraceProcess create(RecordingOptions options, File outputFile, File scriptFile) throws IOException {
        List<String> commandLine = DTraceProcess.buildCommandLine(options, outputFile, scriptFile);
        ProcessBuilder pc = new ProcessBuilder(commandLine);
        DTraceProcess.log("Executing command \"" + commandLine + "\"");
        Process process = null;
        try {
            process = pc.start();
        }
        catch (IOException e) {
            if (e.getMessage().contains("Cannot run program \"dtrace\"")) {
                System.err.println("Could not run dtrace, need to run as root and have dtrace in PATH");
            }
            throw e;
        }
        return new DTraceProcess(options, process);
    }

    private static void log(String text) {
        if (DTraceProcess.isVerbose()) {
            System.out.println(text);
        }
    }

    public boolean isFinished() {
        try {
            this.m_process.exitValue();
            return true;
        }
        catch (IllegalThreadStateException e) {
            return false;
        }
    }

    public String getErrorMessage() throws IOException {
        StringBuilder messages = new StringBuilder();
        for (String line : IOToolkit.loadFromStream((InputStream)this.m_process.getErrorStream())) {
            messages.append(line);
            messages.append(LINE_SEPARATOR);
        }
        return messages.toString();
    }

    public void waitFor() {
        long recordingTimeInMilliSeconds = 1000L * this.m_options.getRecordingTimeInSeconds();
        final long startTime = this.now();
        final long timeoutTime = startTime + recordingTimeInMilliSeconds * 4L;
        if (recordingTimeInMilliSeconds <= 0L) {
            DTraceProcess.log("Recording time must be higher than zero: " + this.m_options.getRecordingTimeInSeconds());
            return;
        }
        DTraceProcess.log("Waiting for DTrace script to complete. Running time is " + this.m_options.getRecordingTimeInSeconds() + " seconds");
        this.timeouter = new Thread(new Runnable(){

            @Override
            public void run() {
                while (DTraceProcess.this.now() < timeoutTime) {
                    if (DTraceProcess.this.isFinished()) {
                        return;
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                DTraceProcess.this.kill();
                DTraceProcess.this.timedOut = true;
                DTraceProcess.log("DTrace script timed out. Ran for " + (double)(DTraceProcess.this.now() - startTime) * 0.001 + " seconds");
            }
        });
        this.timeouter.start();
        try {
            this.m_process.waitFor();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.timeouter.interrupt();
        if (!this.timedOut) {
            DTraceProcess.log("DTrace script finished. Ran for " + (double)(this.now() - startTime) * 0.001 + " seconds");
        }
    }

    private long now() {
        return System.currentTimeMillis();
    }

    private static List<String> buildCommandLine(RecordingOptions options, File outputFile, File scriptFile) {
        ArrayList<String> args = new ArrayList<String>();
        args.add("dtrace");
        args.add("-Z");
        args.add("-q");
        args.add("-b");
        args.add("16M");
        if (options.isDangerous()) {
            args.add("-w");
        }
        if (options.getProcessIdentifier() > 0) {
            args.add("-p");
            args.add(String.valueOf(options.getProcessIdentifier()));
        }
        args.add("-x");
        args.add("bufpolicy=" + options.getBufferPolicy());
        args.add("-x");
        args.add("dynvarsize=16m");
        args.add("-s");
        args.add(scriptFile.getAbsolutePath());
        args.add("-o");
        args.add(outputFile.getAbsolutePath());
        return args;
    }

    public void kill() {
        this.m_process.destroy();
        if (this.timeouter != null && this.timeouter.isAlive()) {
            this.timeouter.interrupt();
        }
    }
}

