/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.dtrace.recorder;

import com.jrockit.mc.common.persistence.ISettingFetcher;
import com.jrockit.mc.common.persistence.PersistenceToolkit;
import com.jrockit.mc.common.persistence.Setting;

public final class RecordingOptions {
    private static final String RECORDING_TIME = "recordingTime";
    private static final String DANGEROUS = "dangerous";
    private static final String RECORDING_NAME = "recordingName";
    private static final String BUFFER_POLICY = "bufferPolicy";
    private static final long DEFAULT_RECORDING_TIME = 10000000000L;
    private static final String DEFAULT_RECORDING_NAME = "My Recording";
    private static final String DEFAULT_BUFFER_POLICY = "switch";
    private static final boolean DEFAULT_DANGEROUS = true;
    private static final String PROCESS_IDENTIFIER = "processIdentfier";
    private static final long NANOS_PER_SECOND = 1000000000L;
    private final Setting m_setting = new Setting("recordingOptions");

    static {
        PersistenceToolkit.registerFetcher(RecordingOptions.class, (ISettingFetcher)new ISettingFetcher<RecordingOptions>(){

            public Setting getSetting(RecordingOptions recordinGoptions) {
                return recordinGoptions.m_setting;
            }
        });
    }

    public RecordingOptions() {
        this.setRecordingTime(10000000000L);
        this.setRecordingName(DEFAULT_RECORDING_NAME);
        this.setDangerous(true);
        this.setBufferPolicy(DEFAULT_BUFFER_POLICY);
        this.setProcessIdentifier(-1);
    }

    public synchronized void setDangerous(boolean dangerous) {
        this.m_setting.setChildObject(DANGEROUS, (Object)dangerous);
    }

    public synchronized boolean isDangerous() {
        return (Boolean)this.m_setting.getChildObject(DANGEROUS, Boolean.class);
    }

    public synchronized String getRecordingName() {
        return (String)this.m_setting.getChildObject(RECORDING_NAME, String.class);
    }

    public synchronized void setRecordingName(String name) {
        this.m_setting.setChildObject(RECORDING_NAME, (Object)name);
    }

    public synchronized long getRecordingTime() {
        return (Long)this.m_setting.getChildObject(RECORDING_TIME, Long.class);
    }

    public synchronized long getRecordingTimeInSeconds() {
        return ((Long)this.m_setting.getChildObject(RECORDING_TIME, Long.class) + 500000000L) / 1000000000L;
    }

    public synchronized void setRecordingTime(long nanos) {
        this.m_setting.setChildObject(RECORDING_TIME, (Object)nanos);
    }

    public synchronized String getBufferPolicy() {
        return (String)this.m_setting.getChildObject(BUFFER_POLICY, String.class);
    }

    public synchronized void setBufferPolicy(String bufferPolicy) {
        this.m_setting.setChildObject(BUFFER_POLICY, (Object)bufferPolicy);
    }

    public synchronized int getProcessIdentifier() {
        return Integer.parseInt((String)this.m_setting.getChildObject(PROCESS_IDENTIFIER, String.class));
    }

    public synchronized void setProcessIdentifier(int pid) {
        this.m_setting.setChildObject(PROCESS_IDENTIFIER, (Object)Integer.toString(pid));
    }
}

