/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.dtrace.recorder;

import com.jrockit.mc.common.persistence.ISettingFetcher;
import com.jrockit.mc.common.persistence.PersistenceToolkit;
import com.jrockit.mc.common.persistence.Setting;
import com.jrockit.mc.dtrace.recorder.RecordingOptions;
import com.jrockit.mc.dtrace.recorder.RecordingState;
import java.io.File;
import java.util.concurrent.atomic.AtomicInteger;

public final class RecordingDescriptor {
    private static volatile AtomicInteger s_recordingIdentifier = new AtomicInteger();
    private static final String IDENTIFIER = "identifier";
    private static final String FILE_NAME = "fileName";
    private static final String ERROR_MESSAGE = "error";
    private static final String RECORDING_STATE = "recordingState";
    private static final String PROCESS_IDENTIFIER = "processIdentifier";
    private static final String RECORDING_OPTIONS = "recordingOptions";
    private final Setting m_setting = new Setting("recording");

    static {
        PersistenceToolkit.registerFetcher(RecordingDescriptor.class, (ISettingFetcher)new ISettingFetcher<RecordingDescriptor>(){

            public Setting getSetting(RecordingDescriptor recording) {
                return recording.m_setting;
            }
        });
    }

    public RecordingDescriptor(RecordingOptions options) {
        this(options, s_recordingIdentifier.incrementAndGet());
    }

    public RecordingDescriptor() {
        this(new RecordingOptions(), s_recordingIdentifier.incrementAndGet());
    }

    public RecordingDescriptor(RecordingOptions options, int identifier) {
        this.setIdentifier(identifier);
        this.setRecordingOptions(options);
    }

    private synchronized void setRecordingOptions(RecordingOptions recordingOptions) {
        this.m_setting.setChildObject(RECORDING_OPTIONS, (Object)recordingOptions);
    }

    public synchronized void setPID(int pid) {
        this.m_setting.setChildObject(PROCESS_IDENTIFIER, (Object)pid);
    }

    public synchronized String getPID() {
        return (String)this.m_setting.getChildObject(PROCESS_IDENTIFIER, String.class);
    }

    public synchronized RecordingState getRecordingState() {
        return RecordingState.lookup((String)this.m_setting.getChildObject(RECORDING_STATE, String.class));
    }

    public synchronized int getIdentifier() {
        return (Integer)this.m_setting.getChildObject(IDENTIFIER, Integer.class);
    }

    public synchronized File getFile() {
        return new File((String)this.m_setting.getChildObject(FILE_NAME, String.class));
    }

    public synchronized String getErrorMessage() {
        return (String)this.m_setting.getChildObject(ERROR_MESSAGE, String.class);
    }

    public synchronized void setErrorMessages(String message) {
        this.m_setting.setChildObject(ERROR_MESSAGE, (Object)message);
    }

    public synchronized void setState(RecordingState state) {
        this.m_setting.setChildObject(RECORDING_STATE, (Object)state.getIdentifier());
    }

    public synchronized int hashCode() {
        return this.getIdentifier();
    }

    public synchronized boolean equals(Object o) {
        if (o instanceof RecordingDescriptor) {
            RecordingDescriptor thatRecording = (RecordingDescriptor)o;
            return this.getIdentifier() == thatRecording.getIdentifier();
        }
        return false;
    }

    public synchronized void setFile(File file) {
        this.m_setting.setChildObject(FILE_NAME, (Object)file.toString());
    }

    private synchronized void setIdentifier(int id) {
        this.m_setting.setChildObject(IDENTIFIER, (Object)id);
    }

    public synchronized RecordingOptions getRecordingOptions() {
        return (RecordingOptions)this.m_setting.getChildObject(RECORDING_OPTIONS, RecordingOptions.class);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        this.writeEntry(sb, Integer.toString(this.getIdentifier()));
        this.writeEntry(sb, this.getRecordingState().toString());
        sb.append("]");
        return sb.toString();
    }

    private void writeEntry(StringBuilder sb, String string) {
        sb.append(string);
        sb.append(";");
    }
}

