/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.dtrace.recorder;

import com.jrockit.mc.common.jvm.Connectable;
import com.jrockit.mc.common.jvm.JVMArch;
import com.jrockit.mc.common.jvm.JVMCommandLineToolkit;
import com.jrockit.mc.common.jvm.JVMDescriptor;
import com.jrockit.mc.common.jvm.JVMType;
import com.jrockit.mc.common.persistence.ISettingFetcher;
import com.jrockit.mc.common.persistence.PersistenceToolkit;
import com.jrockit.mc.common.persistence.Setting;

public final class ProcessDescriptor {
    protected final Setting m_setting = new Setting("process");
    private static final String PID = "identifier";
    private static final String EXECUTABLE = "executable";
    private static final String PATH = "path";
    private static final String ARGUMENTS = "arguments";

    static {
        PersistenceToolkit.registerFetcher(ProcessDescriptor.class, (ISettingFetcher)new ISettingFetcher<ProcessDescriptor>(){

            public Setting getSetting(ProcessDescriptor probeDescriptor) {
                return probeDescriptor.m_setting;
            }
        });
    }

    public int hashCode() {
        return this.getIdentifier();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ProcessDescriptor) {
            return ((ProcessDescriptor)obj).getIdentifier() == this.getIdentifier();
        }
        return false;
    }

    public synchronized void setIdentifier(int identifier) {
        this.m_setting.setChildObject(PID, (Object)identifier);
    }

    public synchronized int getIdentifier() {
        return (Integer)this.m_setting.getChildObject(PID, Integer.class);
    }

    public synchronized void setExecutable(String executable) {
        this.m_setting.setChildObject(EXECUTABLE, (Object)executable);
    }

    public synchronized String getExecutable() {
        return (String)this.m_setting.getChildObject(EXECUTABLE, String.class);
    }

    public synchronized void setPath(String path) {
        this.m_setting.setChildObject(PATH, (Object)path);
    }

    public synchronized String getPath() {
        return (String)this.m_setting.getChildObject(PATH, String.class);
    }

    public synchronized void setArguments(String arguments) {
        this.m_setting.setChildObject(ARGUMENTS, (Object)arguments);
    }

    public synchronized String getArguments() {
        return (String)this.m_setting.getChildObject(ARGUMENTS, String.class);
    }

    public String toString() {
        return "[" + this.getIdentifier() + ";" + this.getPath() + ";" + this.getExecutable() + ";" + this.getArguments() + "]";
    }

    public JVMDescriptor toJVMDescriptor() {
        return new JVMDescriptor("", JVMType.HOTSPOT, JVMArch.UNKNOWN, JVMCommandLineToolkit.getJavaCommandLine((String)this.getArguments()), Integer.valueOf(this.getIdentifier()), Boolean.FALSE.booleanValue(), Connectable.UNKNOWN);
    }
}

